/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.dataimport.nodel.DataItem;
import com.ibm.neo.dataimport.nodel.DeploymentPlan;
import com.ibm.neo.dataimport.nodel.Grouping;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Dataset
extends Nobject {
    public static final String KEY_DATA_SOURCE_ID = "data-source-id";
    public static final String KEY_NAME = "name";
    public static final String KEY_LABEL = "label";
    public static final String KEY_ROW_COUNT = "row-count";
    public static final String KEY_DATA_ITEMS = "data-items";
    public static final String KEY_PLAN = "plan";
    public static final String KEY_CREATED_TIME = "created-time";
    public static final String KEY_MODIFIED_TIME = "modified-time";
    public static final String KEY_LAST_ACCESS_TIME = "last-access-time";
    public static final String KEY_GROUPINGS = "groupings";
    public static final String KEY_STORAGE_COST = "storage-cost";
    public static final String KEY_REPAIR_NEEDED = "repair-needed";
    public static final String KEY_REPAIR_FAILURE_COUNT = "repair-failure-count";
    public static final String KEY_LAST_REPAIR_TIME = "last-repair-time";
    public static final String KEY_VERSION = "version";
    public static final String EXT_KEY_SKIP_DEPLOY = "skip-deploy";
    public static final String EXT_KEY_RELATED_ARTIFACTS = "related-artifacts";
    private IONObjectId mDataSourceId;
    private String mName;
    private String mLabel;
    private long mRowCount;
    private final List<DataItem> mDataItems = new ArrayList<DataItem>();
    private final List<DeploymentPlan> mPlans = new ArrayList<DeploymentPlan>(1);
    private Date mCreatedTime = new Date(0L);
    private Date mModifiedTime = new Date(0L);
    private Date mLastAccessTime = new Date(0L);
    private List<Grouping> mGroupings;
    private double mStorageCost = 1.0;
    private boolean mRepairNeeded = false;
    private int mRepairFailureCount = 0;
    private Date mLastRepairTime = new Date(0L);
    private int mVersion = 0;

    public IONObjectId getDataSourceId() {
        return this.mDataSourceId;
    }

    public void setDataSourceId(IONObjectId dataSourceId) {
        this.mDataSourceId = dataSourceId;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getLabel() {
        if (this.mLabel == null) {
            this.mLabel = this.makeLabelFromName(this.getName());
        }
        return this.mLabel;
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public long getRowCount() {
        return this.mRowCount;
    }

    public void setRowCount(long rowCount) {
        this.mRowCount = rowCount;
    }

    public List<DataItem> getDataItems() {
        return this.mDataItems;
    }

    public DataItem findDataItem(String name) {
        if (null != this.mDataItems) {
            for (DataItem di : this.mDataItems) {
                if (!di.getName().equals(name)) continue;
                return di;
            }
        }
        return null;
    }

    public DeploymentPlan getPlan() {
        return this.mPlans.get(0);
    }

    public List<DeploymentPlan> getPlans() {
        return this.mPlans;
    }

    public List<Grouping> getGroupings() {
        return this.mGroupings;
    }

    public void addGrouping(Grouping grouping) {
        if (this.mGroupings == null) {
            this.mGroupings = new ArrayList<Grouping>();
        }
        this.mGroupings.add(grouping);
    }

    public Date getCreatedTime() {
        return this.mCreatedTime;
    }

    public void setCreatedTime(Date time) {
        this.mCreatedTime = time;
    }

    public Date getModifiedTime() {
        return this.mModifiedTime;
    }

    public void setModifiedTime(Date time) {
        this.mModifiedTime = time;
    }

    public Date getLastAccessTime() {
        return this.mLastAccessTime;
    }

    public void setLastAccessTime(Date time) {
        this.mLastAccessTime = time;
    }

    public double getStorageCost() {
        return this.mStorageCost;
    }

    public void setStorageCost(double storageCost) {
        this.mStorageCost = storageCost;
    }

    public boolean isRepairNeeded() {
        return this.mRepairNeeded;
    }

    public void setRepairNeeded(boolean isRepairNeeded) {
        this.mRepairNeeded = isRepairNeeded;
    }

    public int getRepairFailureCount() {
        return this.mRepairFailureCount;
    }

    public void setRepairFailureCount(int repairFailureCount) {
        this.mRepairFailureCount = repairFailureCount;
    }

    public Date getLastRepairTime() {
        return this.mLastRepairTime;
    }

    public void setLastRepairTime(Date lastRepairTime) {
        this.mLastRepairTime = lastRepairTime;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public void setVersion(int versionHash) {
        this.mVersion = versionHash;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)KEY_DATA_SOURCE_ID, (Object)this.mDataSourceId);
        ionObj.put((Object)KEY_NAME, (Object)this.mName);
        ionObj.putIfNotNull(KEY_LABEL, (Object)this.mLabel);
        ionObj.put((Object)KEY_ROW_COUNT, (Object)this.mRowCount);
        ionObj.put((Object)KEY_DATA_ITEMS, (Object)IONHelper.toIONArray(this.mDataItems));
        if (this.mPlans.size() == 1) {
            ionObj.put((Object)KEY_PLAN, IONHelper.toION((Object)((Object)this.mPlans.get(0))));
        } else if (this.mPlans.size() > 1) {
            ionObj.put((Object)KEY_PLAN, IONHelper.toION(this.mPlans));
        }
        ionObj.put((Object)KEY_CREATED_TIME, (Object)this.mCreatedTime);
        ionObj.put((Object)KEY_MODIFIED_TIME, (Object)this.mModifiedTime);
        ionObj.put((Object)KEY_LAST_ACCESS_TIME, (Object)this.mLastAccessTime);
        ionObj.put((Object)KEY_STORAGE_COST, (Object)this.mStorageCost);
        ionObj.put((Object)KEY_REPAIR_NEEDED, (Object)this.mRepairNeeded);
        ionObj.put((Object)KEY_REPAIR_FAILURE_COUNT, (Object)this.mRepairFailureCount);
        ionObj.put((Object)KEY_LAST_REPAIR_TIME, (Object)this.mLastRepairTime);
        ionObj.put((Object)KEY_VERSION, (Object)this.mVersion);
        if (this.mGroupings != null) {
            Collections.sort(this.mGroupings);
            ionObj.put((Object)KEY_GROUPINGS, (Object)IONHelper.toIONArray(this.mGroupings));
        }
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mDataSourceId = ionObj.getIONObjectId(KEY_DATA_SOURCE_ID);
        this.mName = ionObj.getString(KEY_NAME);
        this.mLabel = ionObj.getString(KEY_LABEL);
        this.mRowCount = ionObj.getLong(KEY_ROW_COUNT, 0L);
        this.mCreatedTime = ionObj.getDate(KEY_CREATED_TIME, new Date(0L));
        this.mModifiedTime = ionObj.getDate(KEY_MODIFIED_TIME, new Date(0L));
        this.mLastAccessTime = ionObj.getDate(KEY_LAST_ACCESS_TIME, new Date(0L));
        this.mStorageCost = ionObj.getDouble(KEY_STORAGE_COST, 1.0);
        this.mRepairNeeded = ionObj.getBoolean(KEY_REPAIR_NEEDED, false);
        this.mRepairFailureCount = ionObj.getInt(KEY_REPAIR_FAILURE_COUNT, 0);
        this.mLastRepairTime = ionObj.getDate(KEY_LAST_REPAIR_TIME, new Date(0L));
        this.mVersion = ionObj.getInt(KEY_VERSION, 0);
        this.mDataItems.clear();
        IONHelper.toCollection((IONArray)ionObj.getIONArray(KEY_DATA_ITEMS), this.mDataItems, DataItem.class);
        this.mPlans.clear();
        Object planObj = ionObj.get((Object)KEY_PLAN);
        if (planObj instanceof IONArray) {
            IONHelper.toCollection((IONArray)((IONArray)planObj), this.mPlans, DeploymentPlan.class);
        } else if (planObj instanceof IONObject) {
            this.mPlans.add((DeploymentPlan)((Object)IONHelper.toPOJO((IONObject)((IONObject)planObj), DeploymentPlan.class)));
        }
        if (ionObj.containsKey((Object)KEY_GROUPINGS)) {
            this.mGroupings = new ArrayList<Grouping>();
            IONHelper.toCollection((IONArray)ionObj.getIONArray(KEY_GROUPINGS), this.mGroupings, Grouping.class);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getDataSourceId(), (Object)other.getDataSourceId()).append((Object)this.getName(), (Object)other.getName()).append(this.getRowCount(), other.getRowCount()).append(this.getDataItems(), other.getDataItems()).append(this.getPlans(), other.getPlans()).append(this.getGroupings(), other.getGroupings()).append((Object)this.getCreatedTime(), (Object)other.getCreatedTime()).append((Object)this.getModifiedTime(), (Object)other.getModifiedTime()).append((Object)this.getLastAccessTime(), (Object)other.getLastAccessTime()).append(this.getStorageCost(), other.getStorageCost()).append(this.isRepairNeeded(), other.isRepairNeeded()).append(this.getRepairFailureCount(), other.getRepairFailureCount()).append((Object)this.getLastRepairTime(), (Object)other.getLastRepairTime()).append(this.getVersion(), other.getVersion()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getDataSourceId()).append((Object)this.getName()).append(this.getRowCount()).append(this.getDataItems()).append(this.getPlans()).append(this.getGroupings()).append((Object)this.getCreatedTime()).append((Object)this.getModifiedTime()).append(this.getStorageCost()).append(this.isRepairNeeded()).append(this.getRepairFailureCount()).append((Object)this.getLastRepairTime()).append(this.getVersion()).toHashCode();
    }

    private String makeLabelFromName(String name) {
        if (name == null) {
            return null;
        }
        String DSV_MARKER = " DSV";
        String CSV_EXTENSION = ".csv";
        String EXCEL_MARKER = " Workbook/";
        if (name.endsWith(" DSV")) {
            String label = name.substring(0, name.lastIndexOf(" DSV"));
            if (label.endsWith(".csv")) {
                label = label.substring(0, label.lastIndexOf(".csv"));
            }
            return label;
        }
        if (name.contains(" Workbook/")) {
            return name.substring(name.lastIndexOf(" Workbook/") + " Workbook/".length(), name.length());
        }
        return name;
    }
}

