/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.dataimport.nodel.CrossTabInfo;
import com.ibm.neo.dataimport.nodel.Grouping;
import com.ibm.neo.dataimport.nodel.MetadataItem;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DocumentMetadata
extends Nobject {
    private String name = null;
    private String fieldDelimiter = null;
    private String locale = null;
    private String charset = null;
    private MetadataItem[] dataItems = null;
    private CrossTabInfo crossTabInfo = null;
    private String[] nullTokens = null;
    private Integer firstDataRow = null;
    private Integer rowLimit = null;
    private String quotesChar = null;
    private Integer stringLengthLimit = null;
    private Map<Integer, Integer> fieldStringLengthLimits = null;
    private MetadataItem[] dataOverrides = null;
    private IONObject relatedArtifacts = null;
    private Grouping[] groupings = null;

    public DocumentMetadata() {
    }

    public DocumentMetadata(String name, String fieldDelimiter, String locale, String charset, MetadataItem[] dataItems, CrossTabInfo crossTabInfo, String[] nullTokens, Integer firstDataRow, Integer rowLimit, String quotesChar, Integer stringLenghtLimit, Map<Integer, Integer> fieldStringLengthLimits, MetadataItem[] dataOverrides, IONObject relatedArtifacts, Grouping[] groupings) {
        this.name = name;
        this.fieldDelimiter = fieldDelimiter;
        this.locale = locale;
        this.charset = charset;
        this.dataItems = dataItems;
        this.crossTabInfo = crossTabInfo;
        this.nullTokens = nullTokens;
        this.firstDataRow = firstDataRow;
        this.rowLimit = rowLimit;
        this.quotesChar = quotesChar;
        this.stringLengthLimit = stringLenghtLimit;
        this.fieldStringLengthLimits = fieldStringLengthLimits;
        this.dataOverrides = dataOverrides;
        this.relatedArtifacts = relatedArtifacts;
        this.groupings = groupings;
    }

    public MetadataItem[] getDataOverrides() {
        return this.dataOverrides;
    }

    public Integer getRowLimit() {
        return this.rowLimit;
    }

    public String getQuotesChar() {
        return this.quotesChar;
    }

    public Integer getStringLenghtLimit() {
        return this.stringLengthLimit;
    }

    public Map<Integer, Integer> getFieldStringLengthLimits() {
        return this.fieldStringLengthLimits;
    }

    public Integer getFieldStringLengthLimit(int index) {
        if (this.fieldStringLengthLimits == null) {
            return null;
        }
        return this.fieldStringLengthLimits.get(index);
    }

    public Integer getFirstDataRow() {
        return this.firstDataRow;
    }

    public String[] getNullTokens() {
        return this.nullTokens;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getCharset() {
        return this.charset;
    }

    public MetadataItem[] getMetadataDataItems() {
        return this.dataItems;
    }

    public CrossTabInfo getCrossTabInfo() {
        return this.crossTabInfo;
    }

    public IONObject getRelatedArtifacts() {
        return this.relatedArtifacts;
    }

    public Grouping[] getGroupings() {
        return this.groupings;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        if (this.name != null) {
            ionObj.put((Object)"name", (Object)this.name);
        }
        if (this.fieldDelimiter != null) {
            ionObj.put((Object)"field-delimiter", (Object)this.fieldDelimiter);
        }
        if (this.crossTabInfo != null) {
            ionObj.put((Object)"crosstab-info", IONHelper.toION((Object)((Object)this.crossTabInfo)));
        }
        if (this.dataItems != null && this.dataItems.length > 0) {
            ionObj.put((Object)"data-items", (Object)IONHelper.toIONArray(Arrays.asList(this.dataItems)));
        }
        if (this.dataOverrides != null && this.dataOverrides.length > 0) {
            ionObj.put((Object)"data-items-overrides", (Object)IONHelper.toIONArray(Arrays.asList(this.dataOverrides)));
        }
        if (this.nullTokens != null && this.nullTokens.length > 0) {
            ionObj.put((Object)"null-tokens", (Object)IONHelper.toIONArray(Arrays.asList(this.nullTokens)));
        }
        if (this.firstDataRow != null) {
            ionObj.put((Object)"first-data-row", (Object)this.firstDataRow);
        }
        if (this.locale != null) {
            ionObj.put((Object)"locale", (Object)this.locale);
        }
        if (this.charset != null) {
            ionObj.put((Object)"charset", (Object)this.charset);
        }
        if (this.rowLimit != null) {
            ionObj.put((Object)"row-limit", (Object)this.rowLimit);
        }
        if (this.quotesChar != null) {
            ionObj.put((Object)"quotes-encapsulate_char", (Object)this.quotesChar);
        }
        if (this.stringLengthLimit != null) {
            ionObj.put((Object)"string-length-limit", (Object)this.stringLengthLimit);
        }
        if (this.relatedArtifacts != null) {
            ionObj.put((Object)"related-artifacts", (Object)this.relatedArtifacts);
        }
        if (this.groupings != null) {
            ionObj.put((Object)"groupings", (Object)IONHelper.toIONArray(Arrays.asList(this.groupings)));
        }
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.name = ionObj.getString("name");
        this.fieldDelimiter = ionObj.getString("field-delimiter");
        if (ionObj.containsKey((Object)"first-data-row")) {
            this.firstDataRow = ionObj.getInt("first-data-row");
        }
        this.crossTabInfo = (CrossTabInfo)((Object)IONHelper.toPOJO((IONObject)ionObj.getIONObject("crosstab-info"), CrossTabInfo.class));
        ArrayList<String> nulls = new ArrayList<String>();
        if (ionObj.containsKey((Object)"null-tokens")) {
            for (Object e : ionObj.getIONArray("null-tokens")) {
                String nn = (String)e;
                nulls.add(nn);
            }
            this.nullTokens = nulls.toArray(new String[0]);
        }
        this.dataItems = DocumentMetadata.getDataItems(ionObj, "data-items");
        this.dataOverrides = DocumentMetadata.getDataItems(ionObj, "data-items-overrides");
        if (ionObj.containsKey((Object)"locale")) {
            this.locale = ionObj.getString("locale");
        }
        if (ionObj.containsKey((Object)"charset")) {
            this.charset = ionObj.getString(this.charset);
        }
        if (ionObj.containsKey((Object)"row-limit")) {
            this.rowLimit = ionObj.getInt("row-limit");
        }
        if (ionObj.containsKey((Object)"quotes-encapsulate_char")) {
            this.quotesChar = ionObj.getString("quotes-encapsulate_char");
        }
        if (ionObj.containsKey((Object)"string-length-limit")) {
            this.stringLengthLimit = ionObj.getInt("string-length-limit");
        }
        if (ionObj.containsKey((Object)"related-artifacts")) {
            this.relatedArtifacts = ionObj.getIONObject("related-artifacts");
        }
        if (ionObj.containsKey((Object)"groupings")) {
            IONHelper.toArray((IONArray)ionObj.getIONArray("groupings"), (Object[])this.groupings);
        }
    }

    private static MetadataItem[] getDataItems(IONObject ionObj, String tagItems) {
        if (ionObj.containsKey((Object)tagItems)) {
            ArrayList<MetadataItem> dil = new ArrayList<MetadataItem>();
            for (Object e : ionObj.getIONArray(tagItems)) {
                MetadataItem di = new MetadataItem();
                di.decodeION((IONObject)e);
                dil.add(di);
            }
            return dil.toArray(new MetadataItem[0]);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getName(), (Object)other.getName()).append((Object)this.getFieldDelimiter(), (Object)other.getFieldDelimiter()).append((Object)this.getCrossTabInfo(), (Object)other.getCrossTabInfo()).append((Object)this.getLocale(), (Object)other.getLocale()).append((Object)this.getCharset(), (Object)other.getCharset()).append((Object[])this.getMetadataDataItems(), (Object[])other.getMetadataDataItems()).append((Object[])this.getNullTokens(), (Object[])other.getNullTokens()).append((Object)this.getFirstDataRow(), (Object)other.getFirstDataRow()).append((Object)this.getRowLimit(), (Object)other.getRowLimit()).append((Object)this.getQuotesChar(), (Object)other.getQuotesChar()).append((Object)this.getStringLenghtLimit(), (Object)other.getStringLenghtLimit()).append((Object[])this.getDataOverrides(), (Object[])other.getDataOverrides()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getName()).append((Object)this.getFieldDelimiter()).append((Object)this.getLocale()).append((Object)this.getCharset()).append((Object[])this.getMetadataDataItems()).append((Object)this.getCrossTabInfo()).append((Object[])this.getNullTokens()).append((Object)this.getFirstDataRow()).append((Object)this.getRowLimit()).append((Object)this.getQuotesChar()).append((Object)this.getStringLenghtLimit()).append((Object[])this.getDataOverrides()).toHashCode();
    }
}

