/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.dataimport.nodel.DocumentSection;
import com.ibm.neo.dataimport.nodel.ModelPath;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DocumentModel
extends Nobject {
    public static final String PROP_MIME_TYPE = "mime-type";
    public static final String PROP_FILENAME = "filename";
    public static final String PROP_CONTEXT_PATH = "context-path";
    private String mType;
    private String mTitle;
    private IONObject mProperties;
    private final List<DocumentSection> mSections = new ArrayList<DocumentSection>();

    public DocumentModel() {
        this("unknown", "No Name");
    }

    public DocumentModel(String type, String title) {
        if (null == type) {
            throw new NullArgumentException("type");
        }
        if (null == title) {
            throw new NullArgumentException("title");
        }
        this.mType = type;
        this.mTitle = title;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        if (null == this.mType) {
            throw new NullArgumentException("type");
        }
        this.mType = type;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        if (null == title) {
            throw new NullArgumentException("title");
        }
        this.mTitle = title;
    }

    public Map<String, Object> getProperties() {
        if (null == this.mProperties) {
            this.mProperties = new IONObject();
        }
        return this.mProperties;
    }

    public int numSections() {
        return this.mSections.size();
    }

    public DocumentSection getSection(int index) {
        return this.mSections.get(index);
    }

    public DocumentSection getSection(String name) {
        for (DocumentSection s : this.mSections) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public DocumentSection[] getSections() {
        return this.mSections.toArray(new DocumentSection[this.mSections.size()]);
    }

    public Object resolvePath(String path) {
        List<String> parts = ModelPath.parse(path);
        if (parts.isEmpty()) {
            return null;
        }
        String part = parts.get(0);
        DocumentSection s = this.getSection(part);
        if (null != s) {
            if (parts.size() > 1) {
                return s.resolvePath(parts.subList(1, parts.size()));
            }
            return s;
        }
        if (parts.size() == 1 && part.startsWith("@")) {
            return this.mProperties.get((Object)part.substring(1));
        }
        return null;
    }

    public DocumentSection createSection() {
        DocumentSection section = new DocumentSection(this);
        this.mSections.add(section);
        return section;
    }

    public boolean removeSection(DocumentSection section) {
        return this.mSections.remove((Object)section);
    }

    public boolean removeSection(String name) {
        int index = 0;
        for (DocumentSection s : this.mSections) {
            if (s.getName().equals(name)) {
                this.mSections.remove(index);
                return true;
            }
            ++index;
        }
        return false;
    }

    public void removeSection(int index) {
        this.mSections.remove(index);
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)"title", (Object)this.mTitle);
        ionObj.put((Object)"type", (Object)this.mType);
        ionObj.put((Object)"properties", (Object)this.mProperties);
        ionObj.put((Object)"sections", (Object)IONHelper.toIONArray(this.mSections));
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mTitle = ionObj.getString("title");
        this.mType = ionObj.getString("type");
        this.mProperties = ionObj.getIONObject("properties");
        this.mSections.clear();
        for (Object e : ionObj.getIONArray("sections")) {
            DocumentSection section = new DocumentSection(this);
            section.decodeION((IONObject)e);
            this.mSections.add(section);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentModel)) {
            return false;
        }
        DocumentModel other = (DocumentModel)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getType(), (Object)other.getType()).append((Object)this.getTitle(), (Object)other.getTitle()).append(this.getProperties(), other.getProperties()).append(this.mSections, other.mSections).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getType()).append((Object)this.getTitle()).append(this.getProperties()).append(this.mSections).toHashCode();
    }
}

