/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.ModelPath;
import com.ibm.neo.dataimport.nodel.SheetInfo;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DocumentSection
extends Nobject {
    private final DocumentModel mDocument;
    private final DocumentSection mParent;
    private String mName;
    private String mType;
    private String mPath;
    private SheetInfo mSheetInfo;
    private IONObject mProperties;
    private final List<DocumentSection> mChildren = new ArrayList<DocumentSection>();

    public DocumentSection(DocumentModel document) {
        this.mDocument = document;
        this.mParent = null;
    }

    public DocumentSection(DocumentModel document, DocumentSection parent) {
        this.mDocument = document;
        this.mParent = parent;
    }

    public DocumentModel getDocument() {
        return this.mDocument;
    }

    public DocumentSection getParent() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        if (null == name) {
            throw new NullArgumentException("name");
        }
        this.mName = name;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public String getPath() {
        if (null == this.mPath) {
            this.mPath = null == this.mParent ? this.mName : ModelPath.make(this.mParent.getPath(), this.mName);
        }
        return this.mPath;
    }

    public SheetInfo getSheetInfo() {
        return this.mSheetInfo;
    }

    public void setSheetInfo(SheetInfo sheetInfo) {
        this.mSheetInfo = sheetInfo;
    }

    public Map<String, Object> getProperties() {
        if (null == this.mProperties) {
            this.mProperties = new IONObject();
        }
        return this.mProperties;
    }

    public int numChildren() {
        return this.mChildren.size();
    }

    public DocumentSection getChild(int index) {
        return this.mChildren.get(index);
    }

    public DocumentSection getChild(String name) {
        for (DocumentSection s : this.mChildren) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public DocumentSection[] getChildren() {
        return this.mChildren.toArray(new DocumentSection[this.mChildren.size()]);
    }

    public DocumentSection createChild() {
        DocumentSection child = new DocumentSection(this.mDocument, this);
        this.mChildren.add(child);
        return child;
    }

    Object resolvePath(List<String> parts) {
        if (parts.isEmpty()) {
            return null;
        }
        String part = parts.get(0);
        DocumentSection s = this.getChild(part);
        if (null != s) {
            if (parts.size() > 1) {
                return s.resolvePath(parts.subList(1, parts.size()));
            }
            return s;
        }
        if (null != this.mProperties && parts.size() == 1 && part.startsWith("@")) {
            return this.mProperties.get((Object)part.substring(1));
        }
        return null;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)"name", (Object)this.mName);
        ionObj.put((Object)"type", (Object)this.mType);
        ionObj.put((Object)"sheet-info", IONHelper.toION((Object)((Object)this.mSheetInfo)));
        ionObj.put((Object)"properties", (Object)this.mProperties);
        if (!this.mChildren.isEmpty()) {
            ionObj.put((Object)"children", (Object)IONHelper.toIONArray(this.mChildren));
        }
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mName = ionObj.getString("name");
        this.mType = ionObj.getString("type");
        this.mSheetInfo = (SheetInfo)((Object)IONHelper.toPOJO((IONObject)ionObj.getIONObject("sheet-info"), SheetInfo.class));
        this.mProperties = ionObj.getIONObject("properties");
        this.mChildren.clear();
        if (ionObj.containsKey((Object)"children")) {
            for (Object e : ionObj.getIONArray("children")) {
                DocumentSection section = new DocumentSection(this.getDocument());
                section.decodeION((IONObject)e);
                this.mChildren.add(section);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentSection)) {
            return false;
        }
        DocumentSection other = (DocumentSection)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getName(), (Object)other.getName()).append((Object)this.getType(), (Object)other.getType()).append((Object)this.getSheetInfo(), (Object)other.getSheetInfo()).append(this.getProperties(), other.getProperties()).append(this.mChildren, other.mChildren).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getName()).append((Object)this.getType()).append((Object)this.getSheetInfo()).append(this.getProperties()).append(this.mChildren).toHashCode();
    }
}

