/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

public enum EDataType {
    BOOLEAN(5, 1),
    INT8(4, 1),
    INT16(6, 2),
    INT32(11, 4),
    INT64(20, 8),
    FLOAT32(13, 4),
    FLOAT64(25, 8),
    DECIMAL64(25, 8),
    CHAR(1, 2),
    STRING(Integer.MAX_VALUE, 2),
    DATE(24, 4),
    TIME(16, 3),
    TIMESTAMP(40, 10);

    private static final EDataType[] VALUES;
    private static final Map<String, EDataType> EXTERNAL_NAME_2_VALUE;
    private final String mExternalName = this.name().toLowerCase();
    private final int mMaxStringLength;
    private final int mUnitStorageCost;

    public static EDataType fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public static EDataType fromExternalName(String externalName) {
        EDataType v = EXTERNAL_NAME_2_VALUE.get(externalName);
        if (null == v) {
            throw new IllegalArgumentException("Invalid external type name: " + externalName);
        }
        return v;
    }

    public static boolean isIntegerType(EDataType type) {
        return EnumSet.of(INT8, INT16, INT32, INT64).contains((Object)type);
    }

    private EDataType(int maxStringLength, int unitStorageCost) {
        this.mMaxStringLength = maxStringLength;
        this.mUnitStorageCost = unitStorageCost;
    }

    public final String externalName() {
        return this.mExternalName;
    }

    public final int maxStringLength() {
        return this.mMaxStringLength;
    }

    public final int unitStorageCost() {
        return this.mUnitStorageCost;
    }

    static {
        VALUES = EDataType.values();
        EXTERNAL_NAME_2_VALUE = new TreeMap<String, EDataType>(String.CASE_INSENSITIVE_ORDER);
        for (EDataType v : VALUES) {
            EXTERNAL_NAME_2_VALUE.put(v.externalName(), v);
        }
    }
}

