/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.dataimport.nodel.EDataType;

public enum EDataTypeGroup {
    CATEGORY("Category"),
    NUMBER("Number"),
    TEXT("Text"),
    DATE("Date"),
    TIME("Time"),
    OTHER("Other");

    private final String label;

    private EDataTypeGroup(String label) {
        this.label = label;
    }

    public static EDataTypeGroup getGroup(EDataType type) {
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT32: 
            case FLOAT64: 
            case DECIMAL64: {
                return NUMBER;
            }
            case CHAR: 
            case STRING: {
                return TEXT;
            }
            case BOOLEAN: {
                return CATEGORY;
            }
            case DATE: 
            case TIMESTAMP: {
                return DATE;
            }
            case TIME: {
                return TIME;
            }
        }
        return OTHER;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isCategory(EDataType type) {
        return CATEGORY.equals((Object)EDataTypeGroup.getGroup(type));
    }

    public boolean isNumber(EDataType type) {
        return NUMBER.equals((Object)EDataTypeGroup.getGroup(type));
    }

    public boolean isText(EDataType type) {
        return TEXT.equals((Object)EDataTypeGroup.getGroup(type));
    }

    public boolean isDate(EDataType type) {
        return DATE.equals((Object)EDataTypeGroup.getGroup(type));
    }

    public boolean isTime(EDataType type) {
        return TIME.equals((Object)EDataTypeGroup.getGroup(type));
    }

    public boolean isOther(EDataType type) {
        return OTHER.equals((Object)EDataTypeGroup.getGroup(type));
    }
}

