/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FormatHints
extends Nobject {
    private boolean mCurrency;
    private String mCurrencySymbol;
    private String mCurrencyCode;
    private boolean mPercent;
    private boolean mPermil;
    private int mGroupingSize;
    private String mFormatPattern;

    public FormatHints() {
    }

    public FormatHints(FormatHints fh) {
        this.mCurrency = fh.hasCurrency();
        this.mCurrencySymbol = fh.getCurrencySymbol();
        this.mCurrencyCode = fh.getCurrencyCode();
        this.mPercent = fh.hasPercent();
        this.mPermil = fh.hasPermil();
        this.mGroupingSize = fh.getGroupingSize();
        this.mFormatPattern = fh.getFormatPattern();
    }

    public void merge(FormatHints fh) {
        this.mCurrency = fh.hasCurrency() ? true : this.mCurrency;
        this.mCurrencySymbol = fh.getCurrencySymbol() != null ? fh.getCurrencySymbol() : this.mCurrencySymbol;
        this.mCurrencyCode = fh.getCurrencyCode() != null ? fh.getCurrencyCode() : this.mCurrencyCode;
        this.mPercent = fh.hasPercent() ? true : this.mPercent;
        this.mPermil = fh.hasPermil() ? true : this.mPermil;
        this.mGroupingSize = fh.getGroupingSize() > 0 ? fh.getGroupingSize() : this.mGroupingSize;
        this.mFormatPattern = fh.getFormatPattern() != null ? fh.getFormatPattern() : this.mFormatPattern;
    }

    public boolean hasCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(boolean hasCurrency) {
        this.mCurrency = hasCurrency;
    }

    public String getCurrencySymbol() {
        return this.mCurrencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.mCurrencySymbol = currencySymbol;
    }

    public String getCurrencyCode() {
        return this.mCurrencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.mCurrencyCode = currencyCode;
    }

    public boolean hasPercent() {
        return this.mPercent;
    }

    public void setPercent(boolean hasPercent) {
        this.mPercent = hasPercent;
    }

    public boolean hasPermil() {
        return this.mPermil;
    }

    public void setPermil(boolean hasPermil) {
        this.mPermil = hasPermil;
    }

    public int getGroupingSize() {
        return this.mGroupingSize;
    }

    public void setGroupingSize(int groupingSize) {
        this.mGroupingSize = groupingSize;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)"has-currency", (Object)this.mCurrency);
        ionObj.put((Object)"currency-symbol", (Object)this.mCurrencySymbol);
        ionObj.put((Object)"currency-code", (Object)this.mCurrencyCode);
        ionObj.put((Object)"has-percent", (Object)this.mPercent);
        ionObj.put((Object)"has-permil", (Object)this.mPermil);
        ionObj.put((Object)"grouping-size", (Object)this.mGroupingSize);
        if (this.mFormatPattern != null) {
            ionObj.put((Object)"format-pattern", (Object)this.mFormatPattern);
        }
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mCurrency = ionObj.getBoolean("has-currency", false);
        this.mCurrencySymbol = ionObj.getString("currency-symbol");
        this.mCurrencyCode = ionObj.getString("currency-code");
        this.mPercent = ionObj.getBoolean("has-percent", false);
        this.mPermil = ionObj.getBoolean("has-permil", false);
        this.mGroupingSize = ionObj.getInt("grouping-size", 0);
        this.mFormatPattern = ionObj.getString("format-pattern");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FormatHints)) {
            return false;
        }
        FormatHints other = (FormatHints)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals((Object)other)).append(this.hasCurrency(), other.hasCurrency()).append((Object)this.getCurrencySymbol(), (Object)other.getCurrencySymbol()).append((Object)this.getCurrencyCode(), (Object)other.getCurrencyCode()).append(this.hasPercent(), other.hasPercent()).append(this.hasPermil(), other.hasPermil()).append(this.getGroupingSize(), other.getGroupingSize()).append((Object)this.getFormatPattern(), (Object)other.getFormatPattern()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.hasCurrency()).append((Object)this.getCurrencySymbol()).append((Object)this.getCurrencyCode()).append(this.hasPercent()).append(this.hasPermil()).append(this.getGroupingSize()).append((Object)this.getFormatPattern()).toHashCode();
    }

    public void setFormatPattern(String pattern) {
        this.mFormatPattern = pattern;
    }

    public String getFormatPattern() {
        return this.mFormatPattern;
    }
}

