/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.dataimport.nodel.Dataset;
import com.ibm.neo.dataimport.nodel.ImportRestApiTask;
import com.ibm.neo.dataimport.nodel.SSLCertificate;
import com.ibm.neo.dataimport.nodel.Signon;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.nobject.NobjectCollection;
import java.util.concurrent.TimeUnit;

public class ImportPersistence {
    private static final String DATA_SOURCES_COL_NAME = "import.data-sources";
    private static final String DATASETS_COL_NAME = "import.datasets";
    private static final String DATASET_REPAIR_LOCKS_COL_NAME = "import.dataset-repair-locks";
    public static final String IMPORT_JOBS_COL_NAME = "import.jobs";
    private static final String IMPORT_REST_API_TASK_COL_NAME = "import.rest-api-tasks";
    private static final String SHEETS_FS_BUCKET_NAME = "import.sheets-fs";
    private static final String UPLOADS_FS_BUCKET_NAME = "import.uploads-fs";
    private static final String IMPORT_SIGNONS = "import.signons";
    private static final String IMPORT_CERTIFICATES = "import.certificates";

    public static NobjectCollection<UserDataSource> getUserDataSourceCollection() throws PersistenceException {
        return ImportPersistence.getUserDataSourceCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<UserDataSource> getUserDataSourceCollection(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        return tenantDB.getNobjectCollection(DATA_SOURCES_COL_NAME, UserDataSource.class);
    }

    public static NobjectCollection<Dataset> getDatasetCollection() throws PersistenceException {
        return ImportPersistence.getDatasetCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Dataset> getDatasetCollection(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        NobjectCollection datasetCol = tenantDB.getNobjectCollection(DATASETS_COL_NAME, Dataset.class);
        datasetCol.getDocumentCollection().ensureSortedIndex(new String[]{"data-source-id"}, new ESortOrder[]{ESortOrder.ASCENDING}, false, false);
        return datasetCol;
    }

    public static IDocumentCollection getDatasetRepairLockCollection() throws PersistenceException {
        return ImportPersistence.getDatasetRepairLockCollection(PersistenceService.getInstance());
    }

    public static IDocumentCollection getDatasetRepairLockCollection(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        IDocumentCollection datasetRepairsCol = tenantDB.getDocumentCollection(DATASET_REPAIR_LOCKS_COL_NAME);
        datasetRepairsCol.ensureSortedIndex(new String[]{"dataset-id"}, new ESortOrder[]{ESortOrder.ASCENDING}, true, false);
        datasetRepairsCol.ensureTTLIndex("timeout", 120);
        return datasetRepairsCol;
    }

    public static NobjectCollection<ImportRestApiTask> getImportRestApiTaskCollection() throws PersistenceException {
        return ImportPersistence.getImportRestApiTaskCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<ImportRestApiTask> getImportRestApiTaskCollection(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        NobjectCollection collection = tenantDB.getNobjectCollection(IMPORT_REST_API_TASK_COL_NAME, ImportRestApiTask.class);
        collection.getDocumentCollection().ensureTTLIndex("timeout", (int)TimeUnit.HOURS.toSeconds(168L));
        return collection;
    }

    public static IFileBucket getSheetsFS() throws PersistenceException {
        return ImportPersistence.getSheetsFS(PersistenceService.getInstance());
    }

    public static IFileBucket getSheetsFS(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        return tenantDB.getFileBucket(SHEETS_FS_BUCKET_NAME);
    }

    public static IFileBucket getUploadsFS() throws PersistenceException {
        return ImportPersistence.getUploadsFS(PersistenceService.getInstance());
    }

    public static IFileBucket getUploadsFS(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        return tenantDB.getFileBucket(UPLOADS_FS_BUCKET_NAME);
    }

    public static NobjectCollection<Signon> getSignonsCollection() throws PersistenceException {
        return ImportPersistence.getSignonsCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Signon> getSignonsCollection(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        return tenantDB.getNobjectCollection(IMPORT_SIGNONS, Signon.class);
    }

    public static NobjectCollection<SSLCertificate> getCertificatesCollection() throws PersistenceException {
        return ImportPersistence.getCertificatesCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<SSLCertificate> getCertificatesCollection(PersistenceService _persistence) throws PersistenceException {
        IDocumentDatabase tenantDB = _persistence.getTenantDatabase();
        return tenantDB.getNobjectCollection(IMPORT_CERTIFICATES, SSLCertificate.class);
    }

    private ImportPersistence() {
    }
}

