/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.dataimport.nodel.ErrorInfo;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.Date;
import java.util.EnumSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ImportRestApiTask
extends Nobject {
    public static final String KEY_DATA_SOURCE_ID = "data-source-id";
    public static final String KEY_STARTED_ON = "started-on";
    public static final String KEY_COMPLETED_ON = "completed-on";
    public static final String KEY_TIMEOUT = "timeout";
    public static final String KEY_STATUS = "status";
    public static final String KEY_PROGRESS = "progress";
    public static final String KEY_ERROR_INFO = "error-info";
    public static final String KEY_DATA_SOURCE_NAME = "data-source-name";
    public static final String KEY_ORIGIN_MIME_TYPE = "origin-mime-type";
    public static final String KEY_CANCEL_REQUESTED = "cancel-requested";
    public static final String KEY_BATCH_JOB_ID = "batch-job-id";
    private IONObjectId mDataSourceId;
    private Date mStarted;
    private Date mCompleted;
    private Date mTimeout;
    private Status mStatus = Status.CREATED;
    private ErrorInfo mErrorInfo;
    private Float mProgress = Float.valueOf(0.0f);
    private String mDataSourceName;
    private String mOriginMimeType;
    private boolean mCancelRequested;
    private String mBatchJobId;

    public IONObjectId getDataSourceId() {
        return this.mDataSourceId;
    }

    public void setDataSourceId(IONObjectId dataSourceId) {
        this.mDataSourceId = dataSourceId;
    }

    public Date getStarted() {
        return this.mStarted;
    }

    public void setStarted(Date started) {
        this.mStarted = started;
    }

    public Date getCompleted() {
        return this.mCompleted;
    }

    public void setCompleted(Date completed) {
        this.mCompleted = completed;
    }

    public Date getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(Date timeout) {
        this.mTimeout = timeout;
    }

    public void removeTimeout() {
        this.setTimeout(null);
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public void setStatus(Status status) {
        this.mStatus = status;
    }

    public ErrorInfo getErrorInfo() {
        return this.mErrorInfo;
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        this.mErrorInfo = errorInfo;
    }

    public float getProgress() {
        return this.mProgress.floatValue();
    }

    public void setProgress(Float progress) {
        this.mProgress = progress;
    }

    public String getDataSourceName() {
        return this.mDataSourceName;
    }

    public void setDataSourceName(String _name) {
        this.mDataSourceName = _name;
    }

    public String getOriginMimeType() {
        return this.mOriginMimeType;
    }

    public void setOriginMimeType(String _type) {
        this.mOriginMimeType = _type;
    }

    public boolean isCancelRequested() {
        return this.mCancelRequested;
    }

    public void setCancelRequested(boolean cancelRequested) {
        this.mCancelRequested = cancelRequested;
    }

    public String getBatchJobId() {
        return this.mBatchJobId;
    }

    public void setBatchJobId(String mJobId) {
        this.mBatchJobId = mJobId;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.putIfNotNull(KEY_DATA_SOURCE_ID, (Object)this.mDataSourceId);
        ionObj.putIfNotNull(KEY_STARTED_ON, (Object)this.mStarted);
        ionObj.putIfNotNull(KEY_COMPLETED_ON, (Object)this.mCompleted);
        ionObj.putIfNotNull(KEY_TIMEOUT, (Object)this.mTimeout);
        ionObj.put((Object)KEY_STATUS, (Object)this.mStatus.toString());
        ionObj.putIfNotNull(KEY_ERROR_INFO, IONHelper.toION((Object)((Object)this.mErrorInfo)));
        ionObj.putIfNotNull(KEY_PROGRESS, (Object)this.mProgress);
        ionObj.putIfNotNull(KEY_DATA_SOURCE_NAME, (Object)this.mDataSourceName);
        ionObj.putIfNotNull(KEY_ORIGIN_MIME_TYPE, (Object)this.mOriginMimeType);
        ionObj.put((Object)KEY_CANCEL_REQUESTED, (Object)this.mCancelRequested);
        ionObj.put((Object)KEY_BATCH_JOB_ID, (Object)this.mBatchJobId);
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mDataSourceId = ionObj.getIONObjectId(KEY_DATA_SOURCE_ID);
        this.mStarted = ionObj.getDate(KEY_STARTED_ON);
        this.mCompleted = ionObj.getDate(KEY_COMPLETED_ON);
        this.mTimeout = ionObj.getDate(KEY_TIMEOUT);
        this.mStatus = Status.valueOf(ionObj.getString(KEY_STATUS));
        this.mErrorInfo = (ErrorInfo)((Object)IONHelper.toPOJO((IONObject)ionObj.getIONObject(KEY_ERROR_INFO), ErrorInfo.class));
        this.mProgress = Float.valueOf(ionObj.getFloat(KEY_PROGRESS, 0.0f));
        this.mDataSourceName = ionObj.getString(KEY_DATA_SOURCE_NAME);
        this.mOriginMimeType = ionObj.getString(KEY_ORIGIN_MIME_TYPE);
        this.mCancelRequested = ionObj.getBoolean(KEY_CANCEL_REQUESTED, false);
        this.mBatchJobId = ionObj.getString(KEY_BATCH_JOB_ID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportRestApiTask)) {
            return false;
        }
        ImportRestApiTask other = (ImportRestApiTask)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getDataSourceId(), (Object)other.getDataSourceId()).append((Object)this.getStarted(), (Object)other.getStarted()).append((Object)this.getCompleted(), (Object)other.getCompleted()).append((Object)this.getTimeout(), (Object)other.getTimeout()).append((Object)this.getStatus(), (Object)other.getStatus()).append((Object)this.getErrorInfo(), (Object)other.getErrorInfo()).append(this.getProgress(), other.getProgress()).append((Object)this.getDataSourceName(), (Object)other.getDataSourceName()).append((Object)this.getOriginMimeType(), (Object)other.getOriginMimeType()).append(this.isCancelRequested(), other.isCancelRequested()).append((Object)this.getBatchJobId(), (Object)other.getBatchJobId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getDataSourceId()).append((Object)this.getStarted()).append((Object)this.getCompleted()).append((Object)this.getTimeout()).append((Object)this.getStatus()).append((Object)this.getErrorInfo()).append(this.getProgress()).append((Object)this.getDataSourceName()).append((Object)this.getOriginMimeType()).append(this.isCancelRequested()).append((Object)this.getBatchJobId()).toHashCode();
    }

    public boolean isRunning() {
        return ImportRestApiTask.isRunning(this.mStatus);
    }

    public static boolean isRunning(Status status) {
        return Status.runningStates().contains((Object)status);
    }

    public static boolean isRunning(String status) {
        return ImportRestApiTask.isRunning(Status.valueOf(status));
    }

    public String toString() {
        return "ImportRestApiTask [mDataSourceId=" + this.mDataSourceId + ", mStarted=" + this.mStarted + ", mCompleted=" + this.mCompleted + ", mTimeout=" + this.mTimeout + ", mStatus=" + (Object)((Object)this.mStatus) + ", mErrorInfo=" + (Object)((Object)this.mErrorInfo) + ", mProgress=" + this.mProgress + ", mDataSourceName=" + this.mDataSourceName + ", mOriginMimeType=" + this.mOriginMimeType + ", mCancelRequested=" + this.mCancelRequested + ", mBatchJobId=" + this.mBatchJobId + "]";
    }

    public static enum Status {
        CREATED,
        STARTING,
        WAITING,
        IMPORTING,
        FAILED,
        FAILED_WITH_WARNING,
        CANCELED,
        IMPORTED;


        public static EnumSet<Status> runningStates() {
            return EnumSet.of(STARTING, IMPORTING);
        }
    }
}

