/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.NullArgumentException;

public class ModelPath {
    private static final Pattern PATH_PATTERN = Pattern.compile("(.+?)(?:/|\\z)");

    public static List<String> parse(String path) {
        if (null == path) {
            throw new NullArgumentException("path");
        }
        ArrayList<String> parts = new ArrayList<String>(3);
        Matcher m = PATH_PATTERN.matcher(path.trim());
        while (m.find()) {
            parts.add(m.group(1));
        }
        if (parts.isEmpty()) {
            return Collections.emptyList();
        }
        return parts;
    }

    public static String make(String ... parts) {
        StringBuilder sb = new StringBuilder();
        if (parts.length > 0) {
            sb.append(parts[0]);
        }
        for (int i = 1; i < parts.length; ++i) {
            sb.append('/').append(parts[i]);
        }
        return sb.toString();
    }

    private ModelPath() {
    }
}

