/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.mutable.MutableInt;

public class RowList
extends Nobject
implements Iterable<Object[]> {
    public static final String KEY_SIZE = "size";
    public static final String KEY_MAX_COLUMN_WIDTH = "maxColumnWidth";
    public static final String KEY_MAX_STRING_LENGTHS = "maxStringLengths";
    public static final String KEY_ROWS = "rows";
    private final ArrayList<Object[]> mRows = new ArrayList();
    private final ArrayList<MutableInt> mMaxStringLengths = new ArrayList();
    private int mMaxColumnWidth = 0;

    public RowList() {
    }

    public RowList(int initialCapacity) {
        this.mRows.ensureCapacity(initialCapacity);
    }

    public int size() {
        return this.mRows.size();
    }

    public int maxColumnWidth() {
        return this.mMaxColumnWidth;
    }

    public int maxStringLength(int column) {
        if (column < 0 || column > this.maxColumnWidth()) {
            throw new IndexOutOfBoundsException();
        }
        if (column >= this.mMaxStringLengths.size()) {
            return 0;
        }
        return this.mMaxStringLengths.get(column).intValue();
    }

    public int[] maxStringLengths() {
        int[] lengths = new int[this.maxColumnWidth()];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = this.maxStringLength(i);
        }
        return lengths;
    }

    public Object[] get(int row) {
        return this.mRows.get(row);
    }

    public void add(Object[] row) {
        if (null == row) {
            throw new NullPointerException("row was null");
        }
        this.mRows.add(row);
        this.mMaxColumnWidth = Math.max(this.mMaxColumnWidth, row.length);
        for (int i = 0; i < row.length; ++i) {
            if (!(row[i] instanceof String)) continue;
            this.updateMaxStringLength(i, ((String)row[i]).length());
        }
    }

    private void updateMaxStringLength(int index, int length) {
        while (index >= this.mMaxStringLengths.size()) {
            this.mMaxStringLengths.add(new MutableInt(0));
        }
        MutableInt mi = this.mMaxStringLengths.get(index);
        mi.setValue(Math.max(mi.intValue(), length));
    }

    public void clear() {
        this.mRows.clear();
        this.mMaxColumnWidth = 0;
        this.mMaxStringLengths.clear();
    }

    @Override
    public Iterator<Object[]> iterator() {
        return this.mRows.iterator();
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)KEY_SIZE, (Object)this.mRows.size());
        ionObj.put((Object)KEY_MAX_COLUMN_WIDTH, (Object)this.maxColumnWidth());
        IONArray maxStringLenArr = new IONArray(this.maxColumnWidth());
        for (MutableInt len : this.mMaxStringLengths) {
            maxStringLenArr.add((Object)len.intValue());
        }
        ionObj.put((Object)KEY_MAX_STRING_LENGTHS, (Object)maxStringLenArr);
        IONArray rowsArr = new IONArray(this.size());
        for (Object[] row : this.mRows) {
            rowsArr.add((Object)new IONArray(row));
        }
        ionObj.put((Object)KEY_ROWS, (Object)rowsArr);
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        int size = ionObj.getInt(KEY_SIZE);
        this.mMaxColumnWidth = ionObj.getInt(KEY_MAX_COLUMN_WIDTH);
        this.mMaxStringLengths.clear();
        this.mMaxStringLengths.ensureCapacity(this.mMaxColumnWidth);
        for (Object e : ionObj.getIONArray(KEY_MAX_STRING_LENGTHS)) {
            int n = ((Number)e).intValue();
            this.mMaxStringLengths.add(new MutableInt(n));
        }
        this.mRows.clear();
        this.mRows.ensureCapacity(size);
        for (Object e : ionObj.getIONArray(KEY_ROWS)) {
            IONArray rowArr = (IONArray)e;
            this.mRows.add(rowArr.toArray());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowList)) {
            return false;
        }
        RowList other = (RowList)o;
        if (!super.equals((Object)other)) {
            return false;
        }
        if (this.mMaxColumnWidth != other.mMaxColumnWidth) {
            return false;
        }
        if (!this.mMaxStringLengths.equals(other.mMaxStringLengths)) {
            return false;
        }
        if (this.mRows.size() != other.mRows.size()) {
            return false;
        }
        for (int i = 0; i < this.mRows.size(); ++i) {
            if (Arrays.equals(this.get(i), other.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder().appendSuper(super.hashCode()).append(this.mMaxColumnWidth).append(this.mMaxStringLengths);
        for (Object[] e : this.mRows) {
            hcb.append(e);
        }
        return hcb.toHashCode();
    }
}

