/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.artifacts;

import com.ibm.neo.dataimport.nodel.artifacts.ImportArtifact;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.NobjectCollection;

public class ImportArtifactPersistence {
    private static final String ARTIFACTS_DB_NAME = "artifacts";
    private static final String IMPORT_ARTIFACTS_COL_NAME = "import-artifacts";
    private static final String IMPORT_ARTIFACT_SIGNALS_COL_NAME = "import-artifact-signals";
    private static final int SIGNAL_DOC_SIZE = 200;
    private static final int MAX_NUM_SIGNAL_DOCS = 100000;

    private ImportArtifactPersistence() {
    }

    public static NobjectCollection<ImportArtifact> getArtifactsCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ARTIFACTS_DB_NAME);
        NobjectCollection artifactsCol = db.getNobjectCollection(IMPORT_ARTIFACTS_COL_NAME, ImportArtifact.class);
        artifactsCol.getDocumentCollection().ensureSortedIndex(new String[]{"artifact-id"}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, true, true);
        artifactsCol.getDocumentCollection().ensureTTLIndex("expires", 0);
        return artifactsCol;
    }

    public static IDocumentCollection getArtifactSignalsCappedCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase db = ps.getDatabase(ARTIFACTS_DB_NAME);
        IDocumentCollection col = db.getCappedDocumentCollection(IMPORT_ARTIFACT_SIGNALS_COL_NAME, 20000000, 100000);
        if (col.findOne(new IONObject()) == null) {
            col.insert(new IONObject());
        }
        return col;
    }
}

