/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.ds;

import com.ibm.neo.dataimport.nodel.DocumentMetadata;
import com.ibm.neo.dataimport.nodel.DocumentModel;
import com.ibm.neo.dataimport.nodel.ds.UserDataSource;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class DocumentDataSource
extends UserDataSource {
    public static final String KEY_ARCHIVE_PATH = "archive-path";
    public static final String KEY_DOCUMENT = "document";
    public static final String KEY_APPENDED_DOCUMENTS = "appended-documents";
    public static final String KEY_CONTENT_SIZE = "content-size";
    public static final String KEY_DOCUMENT_METADATA = "document-metadata";
    public static final String MODEL_METADTA = "model-metadata";
    private DocumentModel mDocument = null;
    private final List<DocumentModel> mAppendedDocuments = new ArrayList<DocumentModel>();
    private DocumentMetadata mDocumentMetadata = null;
    private String mModelMetadata = null;
    private long mContentSize = 0L;
    private String mArchivePath = null;

    public DocumentModel getDocument() {
        return this.mDocument;
    }

    public void setDocument(DocumentModel document) {
        this.mDocument = document;
    }

    public List<DocumentModel> getAppendedDocuments() {
        return this.mAppendedDocuments;
    }

    public void setMetadata(DocumentMetadata documentMetadata) {
        this.mDocumentMetadata = documentMetadata;
    }

    public DocumentMetadata getMetadata() {
        return this.mDocumentMetadata;
    }

    public void setModelMetadata(String modelMetadata) {
        this.mModelMetadata = modelMetadata;
    }

    public String getModelMetadata() {
        return this.mModelMetadata;
    }

    public long getContentSize() {
        return this.mContentSize;
    }

    public void setContentSize(long contentSize) {
        this.mContentSize = contentSize;
    }

    public String getArchivePath() {
        return this.mArchivePath;
    }

    public void setArchivePath(String archivePath) {
        this.mArchivePath = archivePath;
    }

    @Override
    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)KEY_DOCUMENT, IONHelper.toION((Object)((Object)this.mDocument)));
        if (this.mAppendedDocuments.size() > 0) {
            ionObj.put((Object)KEY_APPENDED_DOCUMENTS, (Object)IONHelper.toIONArray(this.mAppendedDocuments));
        }
        ionObj.put((Object)KEY_CONTENT_SIZE, (Object)this.mContentSize);
        ionObj.put((Object)KEY_ARCHIVE_PATH, (Object)this.mArchivePath);
        if (this.mDocumentMetadata != null) {
            ionObj.put((Object)KEY_DOCUMENT_METADATA, IONHelper.toION((Object)((Object)this.mDocumentMetadata)));
        }
        if (this.mModelMetadata != null) {
            ionObj.put((Object)MODEL_METADTA, (Object)this.mModelMetadata);
        }
    }

    @Override
    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mDocument = (DocumentModel)((Object)IONHelper.toPOJO((IONObject)ionObj.getIONObject(KEY_DOCUMENT), DocumentModel.class));
        this.mAppendedDocuments.clear();
        if (ionObj.containsKey((Object)KEY_APPENDED_DOCUMENTS)) {
            IONHelper.toCollection((IONArray)ionObj.getIONArray(KEY_APPENDED_DOCUMENTS), this.mAppendedDocuments, DocumentModel.class);
        }
        this.mContentSize = ionObj.getLong(KEY_CONTENT_SIZE, 0L);
        this.mArchivePath = ionObj.getString(KEY_ARCHIVE_PATH);
        if (ionObj.containsKey((Object)KEY_DOCUMENT_METADATA)) {
            this.mDocumentMetadata = (DocumentMetadata)((Object)IONHelper.toPOJO((IONObject)ionObj.getIONObject(KEY_DOCUMENT_METADATA), DocumentMetadata.class));
        }
        this.mModelMetadata = ionObj.getString(MODEL_METADTA);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDataSource)) {
            return false;
        }
        DocumentDataSource other = (DocumentDataSource)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getDocument(), (Object)other.getDocument()).append(this.getAppendedDocuments(), other.getAppendedDocuments()).append((Object)this.getMetadata(), (Object)other.getMetadata()).append((Object)this.getModelMetadata(), (Object)other.getModelMetadata()).append(this.getContentSize(), other.getContentSize()).append((Object)this.getArchivePath(), (Object)other.getArchivePath()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getDocument()).append(this.getAppendedDocuments()).append((Object)this.getMetadata()).append((Object)this.getModelMetadata()).append(this.getContentSize()).append((Object)this.getArchivePath()).toHashCode();
    }
}

