/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.misc;

import com.ibm.neo.dataimport.nodel.misc.CellRange;
import com.ibm.neo.dataimport.nodel.misc.ColumnRange;
import com.ibm.neo.dataimport.nodel.misc.RowRange;
import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONCodable;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CellGroup
implements IONCodable {
    private final List<CellRange> mSubRanges = new ArrayList<CellRange>();
    private CellRange mBoundingBox = CellRange.NULL;

    public CellGroup() {
    }

    public CellGroup(CellRange initialRange) {
        this.add(initialRange);
    }

    public CellGroup(Collection<CellRange> initialRanges) {
        for (CellRange r : initialRanges) {
            this.add(r);
        }
    }

    public CellGroup(CellRange[] initialRanges) {
        this(Arrays.asList(initialRanges));
    }

    public final List<CellRange> getRanges() {
        return Collections.unmodifiableList(this.mSubRanges);
    }

    public final CellRange getBoundingBox() {
        return this.mBoundingBox;
    }

    public final long getCellCount() {
        long count = 0L;
        for (CellRange r : this.mSubRanges) {
            count += r.getArea();
        }
        return count;
    }

    public boolean isEmpty() {
        return this.mBoundingBox.isEmpty();
    }

    public final boolean contains(long rowIndex, int columnIndex) {
        if (this.mBoundingBox.contains(rowIndex, columnIndex)) {
            for (CellRange r : this.mSubRanges) {
                if (!r.contains(rowIndex, columnIndex)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean contains(CellRange range) {
        if (range.isEmpty()) {
            return true;
        }
        if (!this.mBoundingBox.contains(range)) {
            return false;
        }
        ArrayList<CellRange> pieces = new ArrayList<CellRange>();
        pieces.add(range);
        for (CellRange r : this.mSubRanges) {
            for (int i = 0; i < pieces.size(); ++i) {
                if (!((CellRange)pieces.get(i)).isIntersecting(r)) continue;
                CellRange[] newPieces = ((CellRange)pieces.get(i)).carve(r);
                pieces.remove(i);
                --i;
                for (int j = 0; j < newPieces.length; ++j) {
                    if (CellRange.NULL == newPieces[j]) continue;
                    pieces.add(newPieces[j]);
                }
            }
            if (!pieces.isEmpty()) continue;
            break;
        }
        return pieces.isEmpty();
    }

    public boolean contains(CellGroup group) {
        if (group.isEmpty()) {
            return true;
        }
        if (!this.mBoundingBox.contains(group.getBoundingBox())) {
            return false;
        }
        for (CellRange r : group.getRanges()) {
            if (this.contains(r)) continue;
            return false;
        }
        return true;
    }

    public boolean isIntersecting(CellRange range) {
        if (!this.mBoundingBox.isIntersecting(range)) {
            return false;
        }
        for (CellRange r : this.mSubRanges) {
            if (!r.isIntersecting(range)) continue;
            return true;
        }
        return false;
    }

    public long distanceTo(long rowIndex, int columnIndex) {
        long minDistance = Long.MAX_VALUE;
        for (CellRange r : this.mSubRanges) {
            long dist = r.distanceTo(rowIndex, columnIndex);
            if (dist >= minDistance) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public long distanceTo(CellRange range) {
        long minDistance = Long.MAX_VALUE;
        for (CellRange r : this.mSubRanges) {
            long dist = r.distanceTo(range);
            if (dist >= minDistance) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public long distanceTo(CellGroup group) {
        long minDistance = Long.MAX_VALUE;
        for (CellRange r : group.getRanges()) {
            long dist = this.distanceTo(r);
            if (dist >= minDistance) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public void add(long rowIndex, int columnIndex) {
        CellRange rangeToMerge = null;
        for (CellRange r : this.mSubRanges) {
            if (r.contains(rowIndex, columnIndex)) {
                return;
            }
            if (r.distanceTo(rowIndex, columnIndex) != 1L) continue;
            if (r.getRowRange().getStart() == rowIndex && r.getRowRange().getLength() == 1L) {
                rangeToMerge = r;
                break;
            }
            if (r.getColumnRange().getStart() != columnIndex || r.getColumnRange().getLength() != 1) continue;
            rangeToMerge = r;
            break;
        }
        if (null != rangeToMerge) {
            this.mSubRanges.remove(rangeToMerge);
            this.addInternal(rangeToMerge.include(rowIndex, columnIndex), false);
        } else {
            this.mSubRanges.add(CellRange.single(rowIndex, columnIndex));
        }
        this.updateBoundingBox();
    }

    public void add(CellRange range) {
        this.addInternal(range, true);
    }

    public void add(CellGroup group) {
        if (group.isEmpty()) {
            return;
        }
        for (CellRange r : group.getRanges()) {
            this.addInternal(r, false);
        }
        this.updateBoundingBox();
    }

    private void addInternal(CellRange range, boolean updateBounds) {
        if (range.isEmpty()) {
            return;
        }
        ArrayList<CellRange> pieces = new ArrayList<CellRange>();
        pieces.add(range);
        for (CellRange r : this.mSubRanges) {
            for (int i = 0; i < pieces.size(); ++i) {
                if (!((CellRange)pieces.get(i)).isIntersecting(r)) continue;
                CellRange[] newPieces = ((CellRange)pieces.get(i)).carve(r);
                pieces.remove(i);
                --i;
                for (int j = 0; j < newPieces.length; ++j) {
                    if (CellRange.NULL == newPieces[j]) continue;
                    pieces.add(newPieces[j]);
                }
            }
            if (!pieces.isEmpty()) continue;
            break;
        }
        if (pieces.isEmpty()) {
            return;
        }
        for (int i = 0; i < pieces.size(); ++i) {
            CellRange piece = (CellRange)pieces.get(i);
            CellRange rangeToMerge = null;
            for (CellRange r : this.mSubRanges) {
                if (r.distanceTo(piece) != 1L || r.getArea() + piece.getArea() != r.include(piece).getArea()) continue;
                rangeToMerge = r;
                break;
            }
            if (null != rangeToMerge) {
                this.mSubRanges.remove(rangeToMerge);
                this.addInternal(rangeToMerge.include(piece), false);
                continue;
            }
            this.mSubRanges.add(piece);
        }
        if (updateBounds) {
            this.updateBoundingBox();
        }
    }

    public CellGroup duplicate() {
        CellGroup result = new CellGroup();
        result.mSubRanges.addAll(this.mSubRanges);
        result.mBoundingBox = this.mBoundingBox;
        return result;
    }

    public CellGroup retain(CellRange range) {
        CellGroup result = new CellGroup();
        for (CellRange r : this.mSubRanges) {
            CellRange sr = r.intersect(range);
            if (CellRange.NULL == sr) continue;
            result.mSubRanges.add(sr);
        }
        result.updateBoundingBox();
        return result;
    }

    public CellGroup translate(long rowDelta, int columnDelta) {
        CellGroup result = new CellGroup();
        for (CellRange r : this.mSubRanges) {
            result.mSubRanges.add(r.translate(rowDelta, columnDelta));
        }
        result.updateBoundingBox();
        return result;
    }

    public void encodeION(IONObject ionObj) {
        ionObj.put((Object)"sub-ranges", (Object)IONHelper.toIONArray(this.mSubRanges));
    }

    public void decodeION(IONObject ionObj) {
        this.mSubRanges.clear();
        IONArray ionArr = ionObj.getIONArray("sub-ranges");
        if (null != ionArr) {
            for (Object e : ionArr) {
                this.mSubRanges.add(CellRange.fromION((IONObject)e));
            }
        }
        this.updateBoundingBox();
    }

    public String toString() {
        return this.mSubRanges.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellGroup)) {
            return false;
        }
        CellGroup other = (CellGroup)o;
        if (!this.mBoundingBox.equals(other.mBoundingBox)) {
            return false;
        }
        return this.contains(other) && other.contains(this);
    }

    public int hashCode() {
        return this.mSubRanges.hashCode();
    }

    public void readFrom(InputStream in) throws IOException {
        int size = VarIntCoder.readUnsignedVarInt((InputStream)in);
        this.mSubRanges.clear();
        for (int i = 0; i < size; ++i) {
            this.mSubRanges.add(CellRange.fromStream(in));
        }
        this.updateBoundingBox();
    }

    public void writeTo(OutputStream out) throws IOException {
        VarIntCoder.writeUnsignedVarInt((int)this.mSubRanges.size(), (OutputStream)out);
        for (CellRange r : this.mSubRanges) {
            CellRange.toStream(out, r);
        }
    }

    private void updateBoundingBox() {
        if (this.mSubRanges.isEmpty()) {
            this.mBoundingBox = CellRange.NULL;
        } else {
            long minRowIndex = Long.MAX_VALUE;
            long maxRowIndex = Long.MIN_VALUE;
            int minColumnIndex = Integer.MAX_VALUE;
            int maxColumnIndex = Integer.MIN_VALUE;
            for (CellRange r : this.mSubRanges) {
                RowRange rr = r.getRowRange();
                ColumnRange cr = r.getColumnRange();
                if (rr.getStart() < minRowIndex) {
                    minRowIndex = rr.getStart();
                }
                if (rr.getEnd() > maxRowIndex) {
                    maxRowIndex = rr.getEnd();
                }
                if (cr.getStart() < minColumnIndex) {
                    minColumnIndex = cr.getStart();
                }
                if (cr.getEnd() <= maxColumnIndex) continue;
                maxColumnIndex = cr.getEnd();
            }
            this.mBoundingBox = CellRange.withCorners(minRowIndex, minColumnIndex, maxRowIndex - 1L, maxColumnIndex - 1);
        }
    }
}

