/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.misc;

import com.ibm.neo.dataimport.nodel.misc.ColumnRange;
import com.ibm.neo.dataimport.nodel.misc.RowRange;
import com.ibm.neo.persist.ion.IONDecoder;
import com.ibm.neo.persist.ion.IONEncoder;
import com.ibm.neo.persist.ion.IONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class CellRange {
    public static final CellRange NULL = new CellRange(RowRange.NULL, ColumnRange.NULL);
    public static final CellRange ALL = new CellRange(RowRange.ALL, ColumnRange.ALL);
    public static final String KEY_ROWS = "rows";
    public static final String KEY_COLUMNS = "columns";
    public static final IONEncoder ION_ENCODER = new IONEncoder(){

        public IONObject encode(Object obj) {
            return CellRange.toION((CellRange)obj);
        }
    };
    public static final IONDecoder ION_DECODER = new IONDecoder(){

        public <T> T decode(IONObject ionObj, Class<T> expectedType) {
            return expectedType.cast(CellRange.fromION(ionObj));
        }
    };
    private final RowRange mRowRange;
    private final ColumnRange mColumnRange;
    private int mCachedHashCode = -1;

    public static CellRange single(long rowIndex, int columnIndex) {
        return new CellRange(RowRange.single(rowIndex), ColumnRange.single(columnIndex));
    }

    public static CellRange column(int columnIndex) {
        return new CellRange(RowRange.ALL, ColumnRange.single(columnIndex));
    }

    public static CellRange row(long rowIndex) {
        return new CellRange(RowRange.single(rowIndex), ColumnRange.ALL);
    }

    public static CellRange withCorners(long firstRowIndex, int firstColumnIndex, long lastRowIndex, int lastColumnIndex) {
        return new CellRange(new RowRange(firstRowIndex, lastRowIndex + 1L), new ColumnRange(firstColumnIndex, lastColumnIndex + 1));
    }

    public static IONObject toION(CellRange range) {
        if (null == range) {
            throw new NullArgumentException("range");
        }
        IONObject ionObj = new IONObject();
        ionObj.put((Object)KEY_ROWS, (Object)RowRange.toION(range.getRowRange()));
        ionObj.put((Object)KEY_COLUMNS, (Object)ColumnRange.toION(range.getColumnRange()));
        return ionObj;
    }

    public static CellRange fromION(IONObject ionObj) {
        if (null == ionObj) {
            throw new NullArgumentException("ionObj");
        }
        return new CellRange(RowRange.fromION(ionObj.getIONObject(KEY_ROWS)), ColumnRange.fromION(ionObj.getIONObject(KEY_COLUMNS)));
    }

    public static void toStream(OutputStream out, CellRange range) throws IOException {
        if (null == range) {
            throw new NullArgumentException("range");
        }
        RowRange.toStream(out, range.mRowRange);
        ColumnRange.toStream(out, range.mColumnRange);
    }

    public static CellRange fromStream(InputStream in) throws IOException {
        return new CellRange(RowRange.fromStream(in), ColumnRange.fromStream(in));
    }

    public CellRange(RowRange rowRange, ColumnRange columnRange) {
        if (null == columnRange) {
            throw new NullArgumentException("columnRange");
        }
        if (null == rowRange) {
            throw new NullArgumentException("rowRange");
        }
        this.mRowRange = rowRange;
        this.mColumnRange = columnRange;
    }

    public RowRange getRowRange() {
        return this.mRowRange;
    }

    public ColumnRange getColumnRange() {
        return this.mColumnRange;
    }

    public long getArea() {
        return this.mRowRange.getLength() * (long)this.mColumnRange.getLength();
    }

    public boolean contains(long rowIndex, int columnIndex) {
        return this.mRowRange.contains(rowIndex) && this.mColumnRange.contains(columnIndex);
    }

    public boolean contains(CellRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        return this.intersect(other).equals(other);
    }

    public boolean isEmpty() {
        return this.mRowRange.getLength() == 0L || this.mColumnRange.getLength() == 0;
    }

    public long distanceTo(long rowIndex, int columnIndex) {
        return Math.abs(this.mRowRange.distanceTo(rowIndex)) + (long)Math.abs(this.mColumnRange.distanceTo(columnIndex));
    }

    public long distanceTo(CellRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        return Math.abs(this.mRowRange.distanceTo(other.getRowRange())) + Math.abs(this.mColumnRange.distanceTo(other.getColumnRange()));
    }

    public boolean isIntersecting(CellRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        return this.mRowRange.isIntersecting(other.getRowRange()) && this.mColumnRange.isIntersecting(other.getColumnRange());
    }

    public CellRange intersect(CellRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        ColumnRange columnIntersection = this.mColumnRange.intersect(other.getColumnRange());
        RowRange rowIntersection = this.mRowRange.intersect(other.getRowRange());
        if (ColumnRange.NULL == columnIntersection || RowRange.NULL == rowIntersection) {
            return NULL;
        }
        return new CellRange(rowIntersection, columnIntersection);
    }

    public CellRange[] carve(CellRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        CellRange[] pieces = new CellRange[4];
        for (int i = 0; i < 4; ++i) {
            pieces[i] = NULL;
        }
        CellRange intersection = this.intersect(other);
        if (intersection.isEmpty()) {
            pieces[0] = this;
            return pieces;
        }
        if (this.getColumnRange().getStart() < intersection.getColumnRange().getStart()) {
            pieces[0] = new CellRange(intersection.getRowRange(), new ColumnRange(this.getColumnRange().getStart(), intersection.getColumnRange().getStart()));
        }
        if (this.getColumnRange().getEnd() > intersection.getColumnRange().getEnd()) {
            pieces[1] = new CellRange(intersection.getRowRange(), new ColumnRange(intersection.getColumnRange().getEnd(), this.getColumnRange().getEnd()));
        }
        if (this.getRowRange().getStart() < intersection.getRowRange().getStart()) {
            pieces[2] = new CellRange(new RowRange(this.getRowRange().getStart(), intersection.getRowRange().getStart()), this.getColumnRange());
        }
        if (this.getRowRange().getEnd() > intersection.getRowRange().getEnd()) {
            pieces[3] = new CellRange(new RowRange(intersection.getRowRange().getEnd(), this.getRowRange().getEnd()), this.getColumnRange());
        }
        return pieces;
    }

    public CellRange include(long rowIndex, int columnIndex) {
        if (this.contains(rowIndex, columnIndex)) {
            return this;
        }
        return new CellRange(this.mRowRange.include(rowIndex), this.mColumnRange.include(columnIndex));
    }

    public CellRange include(CellRange other) {
        if (this.contains(other)) {
            return this;
        }
        return new CellRange(this.mRowRange.include(other.mRowRange), this.mColumnRange.include(other.mColumnRange));
    }

    public CellRange translate(long rowDelta, int columnDelta) {
        if (rowDelta == 0L && columnDelta == 0) {
            return this;
        }
        return new CellRange(this.mRowRange.translate(rowDelta), this.mColumnRange.translate(columnDelta));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CellRange[rows=").append(this.mRowRange).append(", cols=").append(this.mColumnRange).append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellRange)) {
            return false;
        }
        CellRange other = (CellRange)o;
        return this.mRowRange.equals(other.mRowRange) && this.mColumnRange.equals(other.mColumnRange);
    }

    public int hashCode() {
        if (-1 == this.mCachedHashCode) {
            int hc = new HashCodeBuilder().append((Object)this.mRowRange).append((Object)this.mColumnRange).toHashCode();
            this.mCachedHashCode = -1 == hc ? 0 : hc;
        }
        return this.mCachedHashCode;
    }
}

