/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.misc;

import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.persist.ion.IONDecoder;
import com.ibm.neo.persist.ion.IONEncoder;
import com.ibm.neo.persist.ion.IONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ColumnRange {
    public static final ColumnRange NULL = new ColumnRange(0, 0);
    public static final ColumnRange ALL = new ColumnRange(0, Integer.MAX_VALUE);
    public static final String KEY_START = "start";
    public static final String KEY_END = "end";
    public static final IONEncoder ION_ENCODER = new IONEncoder(){

        public IONObject encode(Object obj) {
            return ColumnRange.toION((ColumnRange)obj);
        }
    };
    public static final IONDecoder ION_DECODER = new IONDecoder(){

        public <T> T decode(IONObject ionObj, Class<T> expectedType) {
            return expectedType.cast(ColumnRange.fromION(ionObj));
        }
    };
    private final int mStart;
    private final int mEnd;

    public static ColumnRange single(int point) {
        return new ColumnRange(point, point + 1);
    }

    public static IONObject toION(ColumnRange range) {
        IONObject ionObj = new IONObject();
        ionObj.put((Object)KEY_START, (Object)range.getStart());
        ionObj.put((Object)KEY_END, (Object)range.getEnd());
        return ionObj;
    }

    public static ColumnRange fromION(IONObject ionObj) {
        return new ColumnRange(ionObj.getInt(KEY_START), ionObj.getInt(KEY_END));
    }

    public static void toStream(OutputStream out, ColumnRange range) throws IOException {
        VarIntCoder.writeUnsignedVarInt((int)range.mStart, (OutputStream)out);
        VarIntCoder.writeUnsignedVarInt((int)range.mEnd, (OutputStream)out);
    }

    public static ColumnRange fromStream(InputStream in) throws IOException {
        return new ColumnRange(VarIntCoder.readUnsignedVarInt((InputStream)in), VarIntCoder.readUnsignedVarInt((InputStream)in));
    }

    public ColumnRange(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("start < 0");
        }
        if (end < 0) {
            throw new IllegalArgumentException("end < 0");
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        this.mStart = start;
        this.mEnd = end;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getEnd() {
        return this.mEnd;
    }

    public int getLength() {
        return this.mEnd - this.mStart;
    }

    public boolean isEmpty() {
        return this.mEnd == this.mStart;
    }

    public boolean contains(int columnIndex) {
        return columnIndex >= this.mStart && columnIndex < this.mEnd;
    }

    public boolean contains(ColumnRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        return this.mStart <= other.mStart && this.mEnd >= other.mEnd;
    }

    public boolean isIntersecting(ColumnRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        return this.mStart < other.mEnd && other.mStart < this.mEnd;
    }

    public int distanceTo(int columnIndex) {
        if (columnIndex < this.mStart) {
            return columnIndex - this.mStart;
        }
        if (columnIndex >= this.mEnd) {
            return columnIndex - this.mEnd + 1;
        }
        return 0;
    }

    public long distanceTo(ColumnRange other) {
        if (this.isIntersecting(other)) {
            return 0L;
        }
        if (other.mStart < this.mStart) {
            return other.mEnd - this.mStart - 1;
        }
        if (other.mStart >= this.mEnd) {
            return other.mStart - this.mEnd + 1;
        }
        return 0L;
    }

    public ColumnRange intersect(ColumnRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        if (this.mStart >= other.mEnd || other.mStart >= this.mEnd) {
            return NULL;
        }
        return new ColumnRange(Math.max(this.mStart, other.mStart), Math.min(this.mEnd, other.mEnd));
    }

    public ColumnRange[] carve(ColumnRange other) {
        ColumnRange intersection = this.intersect(other);
        if (NULL == intersection) {
            return new ColumnRange[]{NULL, NULL};
        }
        if (intersection.mStart > this.mStart) {
            if (intersection.mEnd < this.mEnd) {
                return new ColumnRange[]{new ColumnRange(this.mStart, intersection.mStart), new ColumnRange(intersection.mEnd, this.mEnd)};
            }
            return new ColumnRange[]{new ColumnRange(this.mStart, intersection.mStart), NULL};
        }
        if (intersection.mEnd < this.mEnd) {
            return new ColumnRange[]{NULL, new ColumnRange(intersection.mEnd, this.mEnd)};
        }
        return new ColumnRange[]{NULL, NULL};
    }

    public ColumnRange include(int columnIndex) {
        if (this.contains(columnIndex)) {
            return this;
        }
        return new ColumnRange(Math.min(this.mStart, columnIndex), Math.max(this.mEnd, columnIndex + 1));
    }

    public ColumnRange include(ColumnRange other) {
        if (this.contains(other)) {
            return this;
        }
        return new ColumnRange(Math.min(this.mStart, other.mStart), Math.max(this.mEnd, other.mEnd));
    }

    public ColumnRange translate(int delta) {
        if (delta == 0) {
            return this;
        }
        return new ColumnRange(this.mStart + delta, this.mEnd + delta);
    }

    public String toString() {
        return String.format("[%d, %d)", this.mStart, this.mEnd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnRange)) {
            return false;
        }
        ColumnRange other = (ColumnRange)o;
        return this.mStart == other.mStart && this.mEnd == other.mEnd;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.mStart);
        hcb.append(this.mEnd);
        return hcb.toHashCode();
    }
}

