/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.misc;

import com.ibm.neo.io.VarIntCoder;
import com.ibm.neo.persist.ion.IONDecoder;
import com.ibm.neo.persist.ion.IONEncoder;
import com.ibm.neo.persist.ion.IONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class RowRange {
    public static final RowRange NULL = new RowRange(0L, 0L);
    public static final RowRange ALL = new RowRange(0L, Long.MAX_VALUE);
    public static final String KEY_START = "start";
    public static final String KEY_END = "end";
    public static final IONEncoder ION_ENCODER = new IONEncoder(){

        public IONObject encode(Object obj) {
            return RowRange.toION((RowRange)obj);
        }
    };
    public static final IONDecoder ION_DECODER = new IONDecoder(){

        public <T> T decode(IONObject ionObj, Class<T> expectedType) {
            return expectedType.cast(RowRange.fromION(ionObj));
        }
    };
    private final long mStart;
    private final long mEnd;

    public static RowRange single(long point) {
        return new RowRange(point, point + 1L);
    }

    public static IONObject toION(RowRange range) {
        IONObject ionObj = new IONObject();
        ionObj.put((Object)KEY_START, (Object)range.getStart());
        ionObj.put((Object)KEY_END, (Object)range.getEnd());
        return ionObj;
    }

    public static RowRange fromION(IONObject ionObj) {
        return new RowRange(ionObj.getInt(KEY_START), ionObj.getInt(KEY_END));
    }

    public static void toStream(OutputStream out, RowRange range) throws IOException {
        VarIntCoder.writeUnsignedVarLong((long)range.mStart, (OutputStream)out);
        VarIntCoder.writeUnsignedVarLong((long)range.mEnd, (OutputStream)out);
    }

    public static RowRange fromStream(InputStream in) throws IOException {
        return new RowRange(VarIntCoder.readUnsignedVarLong((InputStream)in), VarIntCoder.readUnsignedVarLong((InputStream)in));
    }

    public RowRange(long start, long end) {
        if (start < 0L) {
            throw new IllegalArgumentException("start < 0");
        }
        if (end < 0L) {
            throw new IllegalArgumentException("end < 0");
        }
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        this.mStart = start;
        this.mEnd = end;
    }

    public long getStart() {
        return this.mStart;
    }

    public long getEnd() {
        return this.mEnd;
    }

    public long getLength() {
        return this.mEnd - this.mStart;
    }

    public boolean isEmpty() {
        return this.mEnd == this.mStart;
    }

    public boolean contains(long rowIndex) {
        return rowIndex >= this.mStart && rowIndex < this.mEnd;
    }

    public boolean contains(RowRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        return this.mStart <= other.mStart && this.mEnd >= other.mEnd;
    }

    public boolean isIntersecting(RowRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        return this.mStart < other.mEnd && other.mStart < this.mEnd;
    }

    public long distanceTo(long rowIndex) {
        if (rowIndex < this.mStart) {
            return rowIndex - this.mStart;
        }
        if (rowIndex >= this.mEnd) {
            return rowIndex - this.mEnd + 1L;
        }
        return 0L;
    }

    public long distanceTo(RowRange other) {
        if (this.isIntersecting(other)) {
            return 0L;
        }
        if (other.mStart < this.mStart) {
            return other.mEnd - this.mStart - 1L;
        }
        if (other.mStart >= this.mEnd) {
            return other.mStart - this.mEnd + 1L;
        }
        return 0L;
    }

    public RowRange intersect(RowRange other) {
        if (null == other) {
            throw new NullArgumentException("other");
        }
        if (this.mStart >= other.mEnd || other.mStart >= this.mEnd) {
            return NULL;
        }
        return new RowRange(Math.max(this.mStart, other.mStart), Math.min(this.mEnd, other.mEnd));
    }

    public RowRange[] carve(RowRange other) {
        RowRange intersection = this.intersect(other);
        if (NULL == intersection) {
            return new RowRange[]{NULL, NULL};
        }
        if (intersection.mStart > this.mStart) {
            if (intersection.mEnd < this.mEnd) {
                return new RowRange[]{new RowRange(this.mStart, intersection.mStart), new RowRange(intersection.mEnd, this.mEnd)};
            }
            return new RowRange[]{new RowRange(this.mStart, intersection.mStart), NULL};
        }
        if (intersection.mEnd < this.mEnd) {
            return new RowRange[]{NULL, new RowRange(intersection.mEnd, this.mEnd)};
        }
        return new RowRange[]{NULL, NULL};
    }

    public RowRange include(long rowIndex) {
        if (this.contains(rowIndex)) {
            return this;
        }
        return new RowRange(Math.min(this.mStart, rowIndex), Math.max(this.mEnd, rowIndex + 1L));
    }

    public RowRange include(RowRange other) {
        if (this.contains(other)) {
            return this;
        }
        return new RowRange(Math.min(this.mStart, other.mStart), Math.max(this.mEnd, other.mEnd));
    }

    public RowRange translate(long delta) {
        if (delta == 0L) {
            return this;
        }
        return new RowRange(this.mStart + delta, this.mEnd + delta);
    }

    public String toString() {
        return String.format("[%d, %d)", this.mStart, this.mEnd);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowRange)) {
            return false;
        }
        RowRange other = (RowRange)o;
        return this.mStart == other.mStart && this.mEnd == other.mEnd;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.mStart);
        hcb.append(this.mEnd);
        return hcb.toHashCode();
    }
}

