/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.storage;

import com.ibm.neo.dataimport.nodel.storage.SQLDataType;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Column
extends Nobject {
    public static final String KEY_COLUMN_NAME = "column-name";
    public static final String KEY_DATA_TYPE = "data-type";
    public static final String KEY_PRIMARY_KEY = "primary-key";
    public static final String KEY_DATA_ITEM_NAME = "data-item-name";
    private String mColumnName;
    private SQLDataType mDataType;
    private String mDataItemName;
    private boolean mPrimaryKey = false;

    public Column() {
    }

    public Column(String columnName, SQLDataType dataType, String dataItemName) {
        this.mColumnName = columnName;
        this.mDataType = dataType;
        this.mDataItemName = dataItemName;
    }

    public String getColumnName() {
        return this.mColumnName;
    }

    public void setColumnName(String columnName) {
        this.mColumnName = columnName;
    }

    public SQLDataType getDataType() {
        return this.mDataType;
    }

    public void setDataType(SQLDataType dataType) {
        this.mDataType = dataType;
    }

    public String getDataItemName() {
        return this.mDataItemName;
    }

    public void setDataItemName(String dataItemName) {
        this.mDataItemName = dataItemName;
    }

    public boolean isPrimaryKey() {
        return this.mPrimaryKey;
    }

    public void setPrimaryKey(boolean isPrimaryKey) {
        this.mPrimaryKey = isPrimaryKey;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)KEY_COLUMN_NAME, (Object)this.mColumnName);
        ionObj.put((Object)KEY_DATA_TYPE, (Object)this.mDataType.toName());
        ionObj.put((Object)KEY_PRIMARY_KEY, (Object)this.mPrimaryKey);
        ionObj.put((Object)KEY_DATA_ITEM_NAME, (Object)this.mDataItemName);
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mColumnName = ionObj.getString(KEY_COLUMN_NAME);
        this.mDataType = SQLDataType.fromName(ionObj.getString(KEY_DATA_TYPE));
        this.mPrimaryKey = ionObj.getBoolean(KEY_PRIMARY_KEY, false);
        this.mDataItemName = ionObj.getString(KEY_DATA_ITEM_NAME);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getColumnName(), (Object)other.getColumnName()).append((Object)this.getDataType(), (Object)other.getDataType()).append(this.isPrimaryKey(), other.isPrimaryKey()).append((Object)this.getDataItemName(), (Object)other.getDataItemName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getColumnName()).append((Object)this.getDataType()).append(this.isPrimaryKey()).append((Object)this.getDataItemName()).toHashCode();
    }
}

