/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.storage;

import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Database
extends Nobject {
    public static final String KEY_NAME = "name";
    public static final String KEY_DB_TYPE = "db-type";
    public static final String KEY_DB_NAME = "db-name";
    public static final String KEY_JDBC_URL = "jdbc-url";
    public static final String KEY_DB2BDM_URL = "db2bdm-url";
    public static final String KEY_DASHDB_URL = "dashdb-url";
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_SSL_ENABLED = "ssl-enabled";
    public static final String KEY_CONNECTION_PROPS = "connection-props";
    public static final String KEY_DEFAULT_ORGANIZED_BY = "default-organized-by";
    public static final String KEY_DISABLED = "disabled";
    public static final String KEY_POOL = "pool";
    public static final String KEY_DEPLOY_SCHEMA = "deploy-schema";
    public static final String EXT_KEY_TABLESPACE_STRIPING_ENABLED = "tablespace-striping-enabled";
    public static final String EXT_KEY_TABLESPACE_STRIPING_PREFIX = "tablespace-striping-prefix";
    public static final String EXT_KEY_TABLESPACE_STRIPING_SIZE = "tablespace-striping-size";
    public static final String EXT_KEY_LOAD_CONCURRENCY = "load-concurrency";
    public static final String EXT_ALLOW_READ_UNCOMMITTED = "allow-read-uncommitted";
    public static final String POOL_DEFAULT = "default";
    private String mName;
    private String mDbType;
    private String mDbName;
    private String mJdbcUrl;
    private String mDb2BdmUrl;
    private String mDashDbUrl;
    private String mUser;
    private String mPassword;
    private boolean mSSLEnabled;
    private IONObject mConnectionProps = new IONObject();
    private EOrganizedBy mDefaultOrganizedBy;
    private boolean mDisabled;
    private String mPool;
    private String mDeploySchema = null;

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDbType() {
        return this.mDbType;
    }

    public void setDbType(String dbType) {
        this.mDbType = dbType;
    }

    public String getDbName() {
        return this.mDbName;
    }

    public void setDbName(String dbName) {
        this.mDbName = dbName;
    }

    public String getJdbcUrl() {
        return this.mJdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.mJdbcUrl = jdbcUrl;
    }

    public String getDb2BdmUrl() {
        return this.mDb2BdmUrl;
    }

    public void setDb2BdmUrl(String db2bdmUrl) {
        this.mDb2BdmUrl = db2bdmUrl;
    }

    public String getDashDbUrl() {
        return this.mDashDbUrl;
    }

    public void setDashDbUrl(String dashDbUrl) {
        this.mDashDbUrl = dashDbUrl;
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String user) {
        this.mUser = user;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public boolean isSSLEnabled() {
        return this.mSSLEnabled;
    }

    public void setSSLEnabled(boolean isSSLEnabled) {
        this.mSSLEnabled = isSSLEnabled;
    }

    public Map<String, Object> getConnectionProps() {
        return this.mConnectionProps;
    }

    public void setConnectionProps(IONObject connectionProps) {
        this.mConnectionProps = connectionProps;
    }

    public EOrganizedBy getDefaultOrganizedBy() {
        return this.mDefaultOrganizedBy;
    }

    public void setDefaultOrganizedBy(EOrganizedBy defaultOrganizedBy) {
        this.mDefaultOrganizedBy = defaultOrganizedBy;
    }

    public boolean isDisabled() {
        return this.mDisabled;
    }

    public void setDisabled(boolean isDisabled) {
        this.mDisabled = isDisabled;
    }

    public String getPool() {
        return this.mPool;
    }

    public void setPool(String pool) {
        this.mPool = pool;
    }

    public String getDeploySchema() {
        return this.mDeploySchema;
    }

    public void setDeploySchema(String deploySchema) {
        this.mDeploySchema = deploySchema;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)KEY_NAME, (Object)this.mName);
        ionObj.put((Object)KEY_DB_TYPE, (Object)this.mDbType);
        ionObj.put((Object)KEY_DB_NAME, (Object)this.mDbName);
        ionObj.put((Object)KEY_JDBC_URL, (Object)this.mJdbcUrl);
        ionObj.putIfNotNull(KEY_DB2BDM_URL, (Object)this.mDb2BdmUrl);
        ionObj.putIfNotNull(KEY_DASHDB_URL, (Object)this.mDashDbUrl);
        ionObj.put((Object)KEY_USER, (Object)this.mUser);
        ionObj.put((Object)KEY_PASSWORD, (Object)this.mPassword);
        ionObj.put((Object)KEY_SSL_ENABLED, (Object)this.mSSLEnabled);
        ionObj.putIfNotNull(KEY_CONNECTION_PROPS, (Object)this.mConnectionProps);
        if (null != this.mDefaultOrganizedBy) {
            ionObj.put((Object)KEY_DEFAULT_ORGANIZED_BY, (Object)this.mDefaultOrganizedBy.externalName());
        }
        ionObj.put((Object)KEY_DISABLED, (Object)this.mDisabled);
        ionObj.putIfNotNull(KEY_POOL, (Object)this.mPool);
        ionObj.putIfNotNull(KEY_DEPLOY_SCHEMA, (Object)this.mDeploySchema);
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mName = ionObj.getString(KEY_NAME);
        this.mDbType = ionObj.getString(KEY_DB_TYPE);
        this.mDbName = ionObj.getString(KEY_DB_NAME);
        this.mJdbcUrl = ionObj.getString(KEY_JDBC_URL);
        this.mDb2BdmUrl = ionObj.getString(KEY_DB2BDM_URL);
        this.mDashDbUrl = ionObj.getString(KEY_DASHDB_URL);
        this.mUser = ionObj.getString(KEY_USER);
        this.mPassword = ionObj.getString(KEY_PASSWORD);
        this.mSSLEnabled = ionObj.getBoolean(KEY_SSL_ENABLED, false);
        this.mDisabled = ionObj.getBoolean(KEY_DISABLED, false);
        this.mPool = ionObj.getString(KEY_POOL);
        this.mDeploySchema = ionObj.getString(KEY_DEPLOY_SCHEMA);
        this.mConnectionProps.clear();
        if (null != ionObj.get((Object)KEY_CONNECTION_PROPS)) {
            this.mConnectionProps.putAll((Map)ionObj.getIONObject(KEY_CONNECTION_PROPS));
        }
        this.mDefaultOrganizedBy = null != ionObj.get((Object)KEY_DEFAULT_ORGANIZED_BY) ? EOrganizedBy.fromExternalName(ionObj.getString(KEY_DEFAULT_ORGANIZED_BY)) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Database)) {
            return false;
        }
        Database other = (Database)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getName(), (Object)other.getName()).append((Object)this.getDbType(), (Object)other.getDbType()).append((Object)this.getDbName(), (Object)other.getDbName()).append((Object)this.getJdbcUrl(), (Object)other.getJdbcUrl()).append((Object)this.getDb2BdmUrl(), (Object)other.getDb2BdmUrl()).append((Object)this.getDashDbUrl(), (Object)other.getDashDbUrl()).append((Object)this.getUser(), (Object)other.getUser()).append((Object)this.getPassword(), (Object)other.getPassword()).append(this.isSSLEnabled(), other.isSSLEnabled()).append(this.getConnectionProps(), other.getConnectionProps()).append((Object)this.getDefaultOrganizedBy(), (Object)other.getDefaultOrganizedBy()).append(this.isDisabled(), other.isDisabled()).append((Object)this.getPool(), (Object)other.getPool()).append((Object)this.getDeploySchema(), (Object)other.getDeploySchema()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getName()).append((Object)this.getDbType()).append((Object)this.getDbName()).append((Object)this.getJdbcUrl()).append((Object)this.getDb2BdmUrl()).append((Object)this.getDashDbUrl()).append((Object)this.getUser()).append((Object)this.getPassword()).append(this.isSSLEnabled()).append(this.getConnectionProps()).append((Object)this.getDefaultOrganizedBy()).append(this.isDisabled()).append((Object)this.getPool()).append((Object)this.getDeploySchema()).toHashCode();
    }
}

