/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.storage;

import java.util.Arrays;

public class SQLDataType {
    private static final SQLDataType CLOB = new SQLDataType(2005, null);
    private static final SQLDataType NCLOB = new SQLDataType(2011, null);
    private static final SQLDataType TINYINT = new SQLDataType(-6, null);
    private static final SQLDataType SMALLINT = new SQLDataType(5, null);
    private static final SQLDataType INT = new SQLDataType(4, null);
    private static final SQLDataType BIGINT = new SQLDataType(-5, null);
    private static final SQLDataType REAL = new SQLDataType(7, null);
    private static final SQLDataType FLOAT = new SQLDataType(6, null);
    private static final SQLDataType DOUBLE = new SQLDataType(8, null);
    private static final SQLDataType BOOLEAN = new SQLDataType(16, null);
    private static final SQLDataType DATE = new SQLDataType(91, null);
    private static final SQLDataType TIME = new SQLDataType(92, null);
    private static final SQLDataType TIMESTAMP = new SQLDataType(93, null);
    private final int mBaseType;
    private final Object[] mParams;

    public static SQLDataType getChar(int length) {
        return new SQLDataType(1, length);
    }

    public static SQLDataType getNChar(int length) {
        return new SQLDataType(-15, length);
    }

    public static SQLDataType getVarChar(int length) {
        return new SQLDataType(12, length);
    }

    public static SQLDataType getNVarChar(int length) {
        return new SQLDataType(-9, length);
    }

    public static SQLDataType getClob() {
        return CLOB;
    }

    public static SQLDataType getNClob() {
        return NCLOB;
    }

    public static SQLDataType getDecimal(int precision, int scale) {
        return new SQLDataType(3, precision, scale);
    }

    public static SQLDataType getTinyInt() {
        return TINYINT;
    }

    public static SQLDataType getSmallInt() {
        return SMALLINT;
    }

    public static SQLDataType getInt() {
        return INT;
    }

    public static SQLDataType getBigInt() {
        return BIGINT;
    }

    public static SQLDataType getReal() {
        return REAL;
    }

    public static SQLDataType getFloat() {
        return FLOAT;
    }

    public static SQLDataType getDouble() {
        return DOUBLE;
    }

    public static SQLDataType getDouble(int precision) {
        return new SQLDataType(8, precision);
    }

    public static SQLDataType getBoolean() {
        return BOOLEAN;
    }

    public static SQLDataType getDate() {
        return DATE;
    }

    public static SQLDataType getTime() {
        return TIME;
    }

    public static SQLDataType getTime(int precision, boolean withTimezone) {
        return new SQLDataType(92, precision, withTimezone);
    }

    public static SQLDataType getTimestamp() {
        return TIMESTAMP;
    }

    public static SQLDataType getTimestamp(int precision, boolean withTimezone) {
        return new SQLDataType(93, precision, withTimezone);
    }

    public SQLDataType(int baseType, Object ... params) {
        this.mBaseType = baseType;
        this.mParams = null == params ? new Object[0] : params;
    }

    public boolean isString() {
        switch (this.mBaseType) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumeric() {
        switch (this.mBaseType) {
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isTemporal() {
        switch (this.mBaseType) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public int getBaseType() {
        return this.mBaseType;
    }

    public Object[] getParams() {
        return this.mParams;
    }

    public String toName() {
        switch (this.mBaseType) {
            case -5: {
                return "BIGINT";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return String.format("CHAR(%d)", (int)((Integer)this.mParams[0]));
            }
            case -15: {
                return String.format("NCHAR(%d)", (int)((Integer)this.mParams[0]));
            }
            case 2005: {
                return "CLOB";
            }
            case 2011: {
                return "NCLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return String.format("DECIMAL(%d, %d)", (int)((Integer)this.mParams[0]), (int)((Integer)this.mParams[1]));
            }
            case 8: {
                if (this.mParams.length == 0) {
                    return "DOUBLE";
                }
                return String.format("DOUBLE(%d)", (int)((Integer)this.mParams[0]));
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INT";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                if (this.mParams.length == 0) {
                    return "TIME";
                }
                if (Boolean.TRUE.equals(this.mParams[1])) {
                    return String.format("TIME(%d) WITH TIME ZONE", (int)((Integer)this.mParams[0]));
                }
                return String.format("TIME(%d)", (int)((Integer)this.mParams[0]));
            }
            case 93: {
                if (this.mParams.length == 0) {
                    return "TIMESTAMP";
                }
                if (Boolean.TRUE.equals(this.mParams[1])) {
                    return String.format("TIMESTAMP(%d) WITH TIME ZONE", (int)((Integer)this.mParams[0]));
                }
                return String.format("TIMESTAMP(%d)", (int)((Integer)this.mParams[0]));
            }
            case -6: {
                return "TINYINT";
            }
            case 12: {
                return String.format("VARCHAR(%d)", (int)((Integer)this.mParams[0]));
            }
            case -9: {
                return String.format("NVARCHAR(%d)", (int)((Integer)this.mParams[0]));
            }
        }
        return "?";
    }

    public static SQLDataType fromName(String name) {
        if ("BIGINT".equals(name)) {
            return SQLDataType.getBigInt();
        }
        if ("BOOLEAN".equals(name)) {
            return SQLDataType.getBoolean();
        }
        if (name.startsWith("CHAR(")) {
            String lengthStr = name.substring(5, name.length() - 1);
            return SQLDataType.getChar(Integer.parseInt(lengthStr));
        }
        if (name.startsWith("NCHAR(")) {
            String lengthStr = name.substring(6, name.length() - 1);
            return SQLDataType.getNChar(Integer.parseInt(lengthStr));
        }
        if (name.startsWith("VARCHAR(")) {
            String lengthStr = name.substring(8, name.length() - 1);
            return SQLDataType.getVarChar(Integer.parseInt(lengthStr));
        }
        if (name.startsWith("NVARCHAR(")) {
            String lengthStr = name.substring(9, name.length() - 1);
            return SQLDataType.getNVarChar(Integer.parseInt(lengthStr));
        }
        if ("CLOB".equals(name)) {
            return SQLDataType.getClob();
        }
        if ("NCLOB".equals(name)) {
            return SQLDataType.getNClob();
        }
        if ("DATE".equals(name)) {
            return SQLDataType.getDate();
        }
        if (name.startsWith("DECIMAL(")) {
            String paramsStr = name.substring(8, name.length() - 1);
            int commaPos = paramsStr.indexOf(44);
            String param1 = paramsStr.substring(0, commaPos).trim();
            String param2 = paramsStr.substring(commaPos + 1, paramsStr.length()).trim();
            return SQLDataType.getDecimal(Integer.parseInt(param1), Integer.parseInt(param2));
        }
        if (name.startsWith("DOUBLE")) {
            if (name.length() == 6) {
                return SQLDataType.getDouble();
            }
            int openBracketPos = name.indexOf(40);
            if (-1 == openBracketPos) {
                throw new RuntimeException("Malformed DOUBLE");
            }
            int closeBracketPos = name.indexOf(41, openBracketPos + 1);
            if (-1 == closeBracketPos) {
                throw new RuntimeException("Malformed DOUBLE");
            }
            String precisionStr = name.substring(openBracketPos + 1, closeBracketPos);
            return SQLDataType.getDouble(Integer.parseInt(precisionStr));
        }
        if ("FLOAT".equals(name)) {
            return SQLDataType.getFloat();
        }
        if ("REAL".equals(name)) {
            return SQLDataType.getReal();
        }
        if ("INT".equals(name)) {
            return SQLDataType.getInt();
        }
        if ("SMALLINT".equals(name)) {
            return SQLDataType.getSmallInt();
        }
        if ("TINYINT".equals(name)) {
            return SQLDataType.getTinyInt();
        }
        if (name.startsWith("TIMESTAMP")) {
            if (name.length() == 9) {
                return SQLDataType.getTimestamp();
            }
            int openBracketPos = name.indexOf(40);
            if (-1 == openBracketPos) {
                throw new RuntimeException("Malformed TIMESTAMP");
            }
            int closeBracketPos = name.indexOf(41, openBracketPos + 1);
            if (-1 == closeBracketPos) {
                throw new RuntimeException("Malformed TIMESTAMP");
            }
            String precisionStr = name.substring(openBracketPos + 1, closeBracketPos);
            return SQLDataType.getTimestamp(Integer.parseInt(precisionStr), name.endsWith("WITH TIME ZONE"));
        }
        if (name.startsWith("TIME")) {
            if (name.length() == 4) {
                return SQLDataType.getTime();
            }
            int openBracketPos = name.indexOf(40);
            if (-1 == openBracketPos) {
                throw new RuntimeException("Malformed TIME");
            }
            int closeBracketPos = name.indexOf(41, openBracketPos + 1);
            if (-1 == closeBracketPos) {
                throw new RuntimeException("Malformed TIME");
            }
            String precisionStr = name.substring(openBracketPos + 1, closeBracketPos);
            return SQLDataType.getTime(Integer.parseInt(precisionStr), name.endsWith("WITH TIME ZONE"));
        }
        throw new RuntimeException("Unsupported type: " + name);
    }

    public String toString() {
        return this.toName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SQLDataType)) {
            return false;
        }
        SQLDataType other = (SQLDataType)o;
        return this.mBaseType == other.mBaseType && Arrays.equals(this.mParams, other.mParams);
    }

    public int hashCode() {
        return this.mBaseType + Arrays.hashCode(this.mParams);
    }
}

