/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.storage;

import com.ibm.neo.dataimport.nodel.storage.Database;
import com.ibm.neo.dataimport.nodel.storage.DeployJob;
import com.ibm.neo.dataimport.nodel.storage.Table;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.nobject.NobjectCollection;

public class StoragePersistence {
    private static final String STORAGE_DB_NAME = "storage";
    private static final String DATABASES_COL_NAME = "databases";
    private static final String TABLES_COL_NAME = "tables";
    public static final String DEPLOY_JOBS_COL_NAME = "deploy-jobs";

    public static IDocumentDatabase getStorageDatabase(PersistenceService ps) throws PersistenceException {
        return ps.getDatabase(STORAGE_DB_NAME);
    }

    public static NobjectCollection<Database> getDatabaseCollection() throws PersistenceException {
        return StoragePersistence.getDatabaseCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Database> getDatabaseCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase storageDB = StoragePersistence.getStorageDatabase(ps);
        NobjectCollection dbCol = storageDB.getNobjectCollection(DATABASES_COL_NAME, Database.class);
        dbCol.getDocumentCollection().ensureSortedIndex(new String[]{"name"}, new ESortOrder[]{ESortOrder.ASCENDING}, true, false);
        return dbCol;
    }

    public static NobjectCollection<Table> getTableCollection() throws PersistenceException {
        return StoragePersistence.getTableCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<Table> getTableCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase storageDB = StoragePersistence.getStorageDatabase(ps);
        NobjectCollection tableCol = storageDB.getNobjectCollection(TABLES_COL_NAME, Table.class);
        tableCol.getDocumentCollection().ensureSortedIndex(new String[]{"database-id", "table-name"}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, false, false);
        tableCol.getDocumentCollection().ensureSortedIndex(new String[]{"tenant-id", "dataset-id"}, new ESortOrder[]{ESortOrder.ASCENDING, ESortOrder.ASCENDING}, false, false);
        return tableCol;
    }

    public static NobjectCollection<DeployJob> getDeployJobCollection() throws PersistenceException {
        return StoragePersistence.getDeployJobCollection(PersistenceService.getInstance());
    }

    public static NobjectCollection<DeployJob> getDeployJobCollection(PersistenceService ps) throws PersistenceException {
        IDocumentDatabase storageDB = StoragePersistence.getStorageDatabase(ps);
        NobjectCollection deployJobCol = storageDB.getNobjectCollection(DEPLOY_JOBS_COL_NAME, DeployJob.class);
        deployJobCol.getDocumentCollection().ensureSortedIndex(new String[]{"database-id"}, new ESortOrder[]{ESortOrder.ASCENDING}, false, false);
        deployJobCol.getDocumentCollection().ensureTTLIndex("validated-date", 60);
        return deployJobCol;
    }

    private StoragePersistence() {
    }
}

