/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel.storage;

import com.ibm.neo.dataimport.nodel.storage.Column;
import com.ibm.neo.dataimport.nodel.storage.EOrganizedBy;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Table
extends Nobject {
    public static final String KEY_TENANT_ID = "tenant-id";
    public static final String KEY_DATASET_ID = "dataset-id";
    public static final String KEY_DATABASE_ID = "database-id";
    public static final String KEY_SCHEMA_NAME = "schema-name";
    public static final String KEY_TABLE_NAME = "table-name";
    public static final String KEY_COLUMNS = "columns";
    public static final String KEY_ORGANIZED_BY = "organized-by";
    public static final String KEY_STORAGE_COST = "storage-cost";
    public static final String KEY_CREATED_TIME = "created-time";
    public static final String KEY_LAST_ACCESS_TIME = "last-access-time";
    public static final String KEY_LAST_VALIDATED_TIME = "last-validated-time";
    public static final String KEY_DELETED = "deleted";
    public static final String KEY_INCONSISTENT = "inconsistent";
    public static final String KEY_DROP_ATTEMPTS = "drop-attempts";
    public static final String KEY_VERSION = "version";
    public static final String EXT_KEY_SKIP_DROP = "skip-drop";
    private IONObjectId mTenantId;
    private IONObjectId mDatasetId;
    private IONObjectId mDatabaseId;
    private String mSchemaName;
    private String mTableName;
    private final List<Column> mColumns = new ArrayList<Column>();
    private EOrganizedBy mOrganizedBy = EOrganizedBy.DEFAULT;
    private double mStorageCost = 1.0;
    private Date mCreatedTime = new Date(0L);
    private Date mLastAccessTime = new Date(0L);
    private Date mLastValidatedTime = new Date(0L);
    private boolean mDeleted = false;
    private boolean mInconsistent = false;
    private int mDropAttempts = 0;
    private int mVersion = 0;

    public IONObjectId getTenantId() {
        return this.mTenantId;
    }

    public void setTenantId(IONObjectId tenantId) {
        this.mTenantId = tenantId;
    }

    public IONObjectId getDatasetId() {
        return this.mDatasetId;
    }

    public void setDatasetId(IONObjectId datasetId) {
        this.mDatasetId = datasetId;
    }

    public IONObjectId getDatabaseId() {
        return this.mDatabaseId;
    }

    public void setDatabaseId(IONObjectId databaseId) {
        this.mDatabaseId = databaseId;
    }

    public String getSchemaName() {
        return this.mSchemaName;
    }

    public void setSchemaName(String schemaName) {
        this.mSchemaName = schemaName;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public void setTableName(String tableName) {
        this.mTableName = tableName;
    }

    public Date getCreatedTime() {
        return this.mCreatedTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.mCreatedTime = createdTime;
    }

    public Date getLastAccessTime() {
        return this.mLastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.mLastAccessTime = lastAccessTime;
    }

    public Date getLastValidatedTime() {
        return this.mLastValidatedTime;
    }

    public void setLastValidatedTime(Date lastValidatedTime) {
        this.mLastValidatedTime = lastValidatedTime;
    }

    public boolean isDeleted() {
        return this.mDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.mDeleted = isDeleted;
    }

    public boolean isInconsistent() {
        return this.mInconsistent;
    }

    public void setInconsistent(boolean isInconsistent) {
        this.mInconsistent = isInconsistent;
    }

    public int getDropAttempts() {
        return this.mDropAttempts;
    }

    public void setDropAttempts(int dropAttempts) {
        this.mDropAttempts = dropAttempts;
    }

    public List<Column> getColumns() {
        return this.mColumns;
    }

    public EOrganizedBy getOrganizedBy() {
        if (null == this.mOrganizedBy) {
            return EOrganizedBy.DEFAULT;
        }
        return this.mOrganizedBy;
    }

    public void setOrganizedBy(EOrganizedBy organizedBy) {
        this.mOrganizedBy = null == organizedBy ? EOrganizedBy.DEFAULT : organizedBy;
    }

    public double getStorageCost() {
        return this.mStorageCost;
    }

    public void setStorageCost(double storageCost) {
        this.mStorageCost = storageCost;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public void setVersion(int version) {
        this.mVersion = version;
    }

    public Column getColumnByName(String columnName) {
        for (Column c : this.mColumns) {
            if (!c.getColumnName().equals(columnName)) continue;
            return c;
        }
        return null;
    }

    public Column getColumnByDataItemName(String dataItemName) {
        for (Column c : this.mColumns) {
            if (null == c.getDataItemName() || !c.getDataItemName().equals(dataItemName)) continue;
            return c;
        }
        return null;
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)KEY_TENANT_ID, (Object)this.mTenantId);
        ionObj.put((Object)KEY_DATASET_ID, (Object)this.mDatasetId);
        ionObj.put((Object)KEY_DATABASE_ID, (Object)this.mDatabaseId);
        ionObj.put((Object)KEY_SCHEMA_NAME, (Object)this.mSchemaName);
        ionObj.put((Object)KEY_TABLE_NAME, (Object)this.mTableName);
        ionObj.put((Object)KEY_COLUMNS, (Object)IONHelper.toIONArray(this.mColumns));
        ionObj.put((Object)KEY_ORGANIZED_BY, (Object)this.mOrganizedBy.externalName());
        ionObj.put((Object)KEY_STORAGE_COST, (Object)this.mStorageCost);
        ionObj.put((Object)KEY_CREATED_TIME, (Object)this.mCreatedTime);
        ionObj.put((Object)KEY_LAST_ACCESS_TIME, (Object)this.mLastAccessTime);
        ionObj.put((Object)KEY_LAST_VALIDATED_TIME, (Object)this.mLastValidatedTime);
        ionObj.put((Object)KEY_DELETED, (Object)this.mDeleted);
        ionObj.put((Object)KEY_INCONSISTENT, (Object)this.mInconsistent);
        ionObj.put((Object)KEY_DROP_ATTEMPTS, (Object)this.mDropAttempts);
        ionObj.put((Object)KEY_VERSION, (Object)this.mVersion);
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.mTenantId = ionObj.getIONObjectId(KEY_TENANT_ID);
        this.mDatasetId = ionObj.getIONObjectId(KEY_DATASET_ID);
        this.mDatabaseId = ionObj.getIONObjectId(KEY_DATABASE_ID);
        this.mSchemaName = ionObj.getString(KEY_SCHEMA_NAME);
        this.mTableName = ionObj.getString(KEY_TABLE_NAME);
        this.mStorageCost = ionObj.getDouble(KEY_STORAGE_COST, 1.0);
        this.mCreatedTime = ionObj.getDate(KEY_CREATED_TIME, new Date(0L));
        this.mLastAccessTime = ionObj.getDate(KEY_LAST_ACCESS_TIME, new Date(0L));
        this.mLastValidatedTime = ionObj.getDate(KEY_LAST_VALIDATED_TIME, new Date(0L));
        this.mDeleted = ionObj.getBoolean(KEY_DELETED, false);
        this.mInconsistent = ionObj.getBoolean(KEY_INCONSISTENT, false);
        this.mDropAttempts = ionObj.getInt(KEY_DROP_ATTEMPTS, 0);
        this.mVersion = ionObj.getInt(KEY_VERSION, 0);
        this.mColumns.clear();
        IONHelper.toCollection((IONArray)ionObj.getIONArray(KEY_COLUMNS), this.mColumns, Column.class);
        this.mOrganizedBy = ionObj.containsKey((Object)KEY_ORGANIZED_BY) ? EOrganizedBy.fromExternalName(ionObj.getString(KEY_ORGANIZED_BY)) : EOrganizedBy.DEFAULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getTenantId(), (Object)other.getTenantId()).append((Object)this.getDatasetId(), (Object)other.getDatasetId()).append((Object)this.getDatabaseId(), (Object)other.getDatabaseId()).append((Object)this.getSchemaName(), (Object)other.getSchemaName()).append((Object)this.getTableName(), (Object)other.getTableName()).append((Object)this.getCreatedTime(), (Object)other.getCreatedTime()).append((Object)this.getLastAccessTime(), (Object)other.getLastAccessTime()).append((Object)this.getLastValidatedTime(), (Object)other.getLastValidatedTime()).append(this.isDeleted(), other.isDeleted()).append(this.isInconsistent(), other.isInconsistent()).append(this.getDropAttempts(), other.getDropAttempts()).append(this.getColumns(), other.getColumns()).append((Object)this.getOrganizedBy(), (Object)other.getOrganizedBy()).append(this.getVersion(), other.getVersion()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.getTenantId()).append((Object)this.getDatasetId()).append((Object)this.getDatabaseId()).append((Object)this.getSchemaName()).append((Object)this.getTableName()).append((Object)this.getCreatedTime()).append((Object)this.getLastAccessTime()).append((Object)this.getLastValidatedTime()).append(this.isDeleted()).append(this.isInconsistent()).append(this.getDropAttempts()).append(this.getColumns()).append((Object)this.getOrganizedBy()).append(this.getVersion()).toHashCode();
    }
}

