/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.soql.cursors;

import com.ibm.cognos.cdms.ds.sforce.request.SForceException;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.CrossProductMatrixGenerator;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.ISForceColumnValue;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.ISForceRecord;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceRecordType;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceTableColumn;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SForceTableRecord
implements ISForceRecord {
    private Map<String, ISForceRecord> children = new LinkedHashMap<String, ISForceRecord>();
    private String name;
    private int size = 0;
    private int[][] crossProductMatrix;

    public SForceTableRecord(String name) {
        this.name = name;
    }

    @Override
    public void initialize(int size) {
        this.size = size;
        this.initializeChildObjects();
    }

    private void initializeChildObjects() {
        Iterator<Map.Entry<String, ISForceRecord>> entryIterator = this.children.entrySet().iterator();
        while (entryIterator.hasNext()) {
            ISForceRecord value = entryIterator.next().getValue();
            if (value.getType() != SForceRecordType.COLUMN) continue;
            value.initialize(this.size);
        }
    }

    public String getName() {
        return this.name;
    }

    private void addColumnRecord(String name) {
        if (this.children.containsKey(name)) {
            throw new SForceException("duplicate column");
        }
        this.children.put(name, new SForceTableColumn());
    }

    private ISForceRecord getColumnRecord(String name) {
        return this.children.get(name);
    }

    private void addTableRecord(String name) {
        if (this.children.containsKey(name)) {
            throw new SForceException("duplicae inner table");
        }
        this.children.put(name, new SForceTableRecord(name));
    }

    private ISForceRecord getTableRecord(String name) {
        return this.children.get(name);
    }

    @Override
    public ISForceColumnValue[] getRecord(int rowNumber) {
        int[][] matrix = this.getInnerTablesCrossProductMatrix();
        int[] rowIndexes = matrix[rowNumber];
        ISForceColumnValue[] record = new ISForceColumnValue[this.getNumberofColumns()];
        Iterator<String> iter = this.children.keySet().iterator();
        int dataCopied = 0;
        int tableIndex = 1;
        while (iter.hasNext()) {
            String columnName = iter.next();
            ISForceRecord recordValue = this.children.get(columnName);
            ISForceColumnValue[] data = null;
            if (recordValue.getSize() > 0) {
                data = recordValue.getType() == SForceRecordType.TABLE ? recordValue.getRecord(rowIndexes[tableIndex++]) : recordValue.getRecord(rowIndexes[0]);
                System.arraycopy(data, 0, record, dataCopied, data.length);
                dataCopied += data.length;
                continue;
            }
            if (recordValue.getType() != SForceRecordType.TABLE) continue;
            dataCopied += ((SForceTableRecord)recordValue).getNumberofColumns();
        }
        return record;
    }

    private int getNumberofColumns() {
        int noOfcols = 0;
        Iterator<Map.Entry<String, ISForceRecord>> entryIterator = this.children.entrySet().iterator();
        while (entryIterator.hasNext()) {
            ISForceRecord value = entryIterator.next().getValue();
            if (value.getType() == SForceRecordType.TABLE) {
                noOfcols += ((SForceTableRecord)value).getNumberofColumns();
                continue;
            }
            ++noOfcols;
        }
        return noOfcols;
    }

    @Override
    public int getSize() {
        return this.size * this.getInnerTablesSize();
    }

    private int getInnerTablesSize() {
        int product = 1;
        Iterator<Map.Entry<String, ISForceRecord>> entryIterator = this.children.entrySet().iterator();
        while (entryIterator.hasNext()) {
            ISForceRecord value = entryIterator.next().getValue();
            if (value.getType() != SForceRecordType.TABLE || value.getSize() <= 0) continue;
            product *= value.getSize();
        }
        return product;
    }

    private int getNumberOfInnerTables() {
        int noOfTables = 0;
        Iterator<Map.Entry<String, ISForceRecord>> entryIterator = this.children.entrySet().iterator();
        while (entryIterator.hasNext()) {
            ISForceRecord value = entryIterator.next().getValue();
            if (value.getType() != SForceRecordType.TABLE) continue;
            ++noOfTables;
        }
        return noOfTables;
    }

    private int[][] getInnerTablesCrossProductMatrix() {
        if (this.crossProductMatrix != null) {
            return this.crossProductMatrix;
        }
        int[] sizes = new int[this.getNumberOfInnerTables() + 1];
        sizes[0] = this.size;
        Iterator<Map.Entry<String, ISForceRecord>> entryIterator = this.children.entrySet().iterator();
        int index = 1;
        while (entryIterator.hasNext()) {
            ISForceRecord value = entryIterator.next().getValue();
            if (value.getType() != SForceRecordType.TABLE || value.getSize() <= 0) continue;
            sizes[index++] = value.getSize();
        }
        this.crossProductMatrix = CrossProductMatrixGenerator.getMatrix(sizes);
        return this.crossProductMatrix;
    }

    @Override
    public SForceRecordType getType() {
        return SForceRecordType.TABLE;
    }

    @Override
    public void addChildRecord(SForceRecordType type, String name) {
        if (type == SForceRecordType.TABLE) {
            this.addTableRecord(name);
        } else {
            this.addColumnRecord(name);
        }
    }

    @Override
    public ISForceRecord getChildRecord(SForceRecordType type, String name) {
        if (type == SForceRecordType.COLUMN) {
            return this.getColumnRecord(name);
        }
        return this.getTableRecord(name);
    }
}

