/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.cdms.ds.sforce.soql.parsers;

import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceRecordType;
import com.ibm.cognos.cdms.ds.sforce.soql.cursors.SForceTableRecord;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.ISForceSOQLQuery;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.SForceSOQLQuerySelectable;
import com.ibm.cognos.cdms.ds.sforce.soql.parsers.SForceSOQLQuerySelectableType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;

public abstract class AbstractSForceSOQLQuery
implements ISForceSOQLQuery {
    protected SForceSOQLQuerySelectable top;
    protected String soql;
    protected int numberOfColumns;
    private int functionsIndex = 0;

    public AbstractSForceSOQLQuery(String soql) {
        this.soql = this.removeSpecialCharacters(soql);
    }

    public HashMap<String, Integer> getPositionMap() {
        LinkedHashMap<String, Integer> posMap = new LinkedHashMap<String, Integer>();
        this.traverse(this.top, posMap);
        return posMap;
    }

    @Override
    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    @Override
    public String getSOQL() {
        return this.soql;
    }

    @Override
    public abstract Set<String> getQueryResultList();

    @Override
    public abstract boolean isQueryResult(String var1);

    @Override
    public abstract Set<String> getSObjectList();

    @Override
    public abstract String getOuterTableName();

    @Override
    public abstract boolean isSObject(String var1);

    private String removeSpecialCharacters(String soql) {
        String newSoql = soql.replaceAll("\n", " ");
        newSoql = newSoql.replaceAll("\r", " ");
        return newSoql;
    }

    private void traverse(SForceSOQLQuerySelectable top, HashMap<String, Integer> posMap) {
        SForceSOQLQuerySelectable[] children = top.getChildrenAsArray();
        if (children != null && children.length > 0) {
            for (SForceSOQLQuerySelectable sel : children) {
                this.traverse(sel, posMap);
            }
        } else {
            posMap.put(top.getFullName().toLowerCase(), top.getPosition());
        }
    }

    protected String getFunctionAlias() {
        return "expr" + this.functionsIndex++;
    }

    @Override
    public SForceTableRecord getTableRecord() {
        SForceTableRecord tableRecord = new SForceTableRecord(this.top.getFullName().toLowerCase());
        this.buildRecordTree(this.top, tableRecord);
        return tableRecord;
    }

    private void buildRecordTree(SForceSOQLQuerySelectable top, SForceTableRecord tableRecord) {
        SForceSOQLQuerySelectable[] children;
        for (SForceSOQLQuerySelectable child : children = top.getChildrenAsArray()) {
            if (child.getType() == SForceSOQLQuerySelectableType.ELEMENT) {
                tableRecord.addChildRecord(SForceRecordType.COLUMN, child.getFullName().toLowerCase());
                continue;
            }
            if (child.getType() == SForceSOQLQuerySelectableType.SOBJECT) {
                this.buildRecordTree(child, tableRecord);
                continue;
            }
            tableRecord.addChildRecord(SForceRecordType.TABLE, child.getFullName().toLowerCase());
            this.buildRecordTree(child, (SForceTableRecord)tableRecord.getChildRecord(SForceRecordType.TABLE, child.getFullName().toLowerCase()));
        }
    }
}

