/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.sfdc.util;

import java.util.HashMap;
import java.util.Map;

public enum DataType {
    CHAR("CHAR"),
    VARCHAR("VARCHAR"),
    BOOLEAN("BOOLEAN"),
    INTEGER("INTEGER"),
    DOUBLE("DOUBLE"),
    DECIMAL("DECIMAL"),
    BIGINT("BIGINT"),
    NUMERIC("NUMERIC"),
    DATE("DATE"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMP_WITH_TIMEZONE("TIMESTAMP_WITH_TIMEZONE"),
    TIME("TIME"),
    NVARCHAR("NVARCHAR"),
    OTHER("OTHER"),
    NULL("NULL");

    private final String value;
    private static final Map<String, DataType> CONSTANTS;

    private DataType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public String value() {
        return this.value;
    }

    public static DataType fromValue(String value) {
        DataType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DataType>();
        for (DataType c : DataType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

