/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.pkcs;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.pkcs.DecryptionResult;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;

class EncryptedContentInfoParser {
    EncryptedContentInfoParser() {
    }

    public static byte[] getData(EncryptedContentInfo info, byte[] secretKeyBytes) throws CAMCryptoException {
        byte[] decryptedData;
        Cipher cipher = EncryptedContentInfoParser.generateCipher(info, secretKeyBytes);
        try {
            decryptedData = cipher.doFinal(info.getEncryptedContent().getOctets());
        }
        catch (IllegalBlockSizeException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
        }
        catch (BadPaddingException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
        }
        return decryptedData;
    }

    public static DecryptionResult getDecryptionResultUsingCSK(EncryptedContentInfo info) throws CAMCryptoException {
        byte[] decryptedData;
        byte[] contentOnly;
        byte[] cskDigestOnly;
        int digestLen = CAMCryptoUtilities.getCSKDigestLength();
        byte[] encrContent = info.getEncryptedContent().getOctets();
        ByteArrayInputStream bais = new ByteArrayInputStream(encrContent);
        try {
            cskDigestOnly = new byte[digestLen];
            bais.read(cskDigestOnly, 0, digestLen);
            contentOnly = new byte[encrContent.length - digestLen];
            bais.read(contentOnly);
        }
        catch (IOException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
        }
        SecretKey csk = KeyStoreReader.getCSKGivenCSKDigest(cskDigestOnly);
        Cipher cipher = EncryptedContentInfoParser.generateCipher(info, csk.getEncoded());
        try {
            decryptedData = cipher.doFinal(contentOnly);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
        }
        byte[] ptheader = new byte[]{0, 67, 65, 77, 0};
        boolean match = true;
        if (decryptedData.length != 0) {
            for (int i = 0; i < ptheader.length; ++i) {
                if (decryptedData[i] == ptheader[i]) continue;
                match = false;
                break;
            }
        } else {
            match = false;
        }
        if (match) {
            byte randomdatalen;
            byte version;
            int pos = ptheader.length;
            if ((version = decryptedData[pos++]) > 1) {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_unknown_encoded_plaintext_version"));
            }
            if ((randomdatalen = decryptedData[pos++]) > 0 && randomdatalen < 32) {
                int nonplaintextpartlen = 7 + randomdatalen;
                int plaintextlen = decryptedData.length - nonplaintextpartlen;
                byte[] actualplaintext = new byte[plaintextlen];
                System.arraycopy(decryptedData, nonplaintextpartlen, actualplaintext, 0, plaintextlen);
                decryptedData = actualplaintext;
            } else {
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
            }
        }
        return new DecryptionResult(cipher, decryptedData);
    }

    private static Cipher generateCipher(EncryptedContentInfo info, byte[] secretKeyBytes) throws CAMCryptoException {
        Cipher cipher;
        block17: {
            String algId = info.getContentEncryptionAlgorithm().getAlgorithm().getId();
            ASN1Encodable encodedParams = info.getContentEncryptionAlgorithm().getParameters();
            ASN1Primitive params = null;
            if (encodedParams != null) {
                params = encodedParams.toASN1Primitive();
            }
            try {
                String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                if (algId.equals("2.16.840.1.101.3.4.1.2") || algId.equals("2.16.840.1.101.3.4.1.42")) {
                    ASN1OctetString iv;
                    cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "AES");
                    try {
                        iv = (ASN1OctetString)params;
                    }
                    catch (ClassCastException cce) {
                        throw new CAMCryptoException(cce, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
                    }
                    cipher.init(2, (Key)key, new IvParameterSpec(iv.getOctets()));
                    break block17;
                }
                if (algId.equals("1.2.840.113549.3.7")) {
                    ASN1OctetString iv;
                    cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "DESede");
                    try {
                        iv = (ASN1OctetString)params;
                    }
                    catch (ClassCastException cce) {
                        throw new CAMCryptoException(cce, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
                    }
                    cipher.init(2, (Key)key, new IvParameterSpec(iv.getOctets()));
                    break block17;
                }
                if (algId.equals("1.3.14.3.2.7")) {
                    ASN1OctetString iv;
                    cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "DES");
                    try {
                        iv = (ASN1OctetString)params;
                    }
                    catch (ClassCastException cce) {
                        throw new CAMCryptoException(cce, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
                    }
                    cipher.init(2, (Key)key, new IvParameterSpec(iv.getOctets()));
                    break block17;
                }
                if (algId.equals("1.2.840.113549.3.2")) {
                    cipher = Cipher.getInstance("RC2/CBC/PKCS5Padding", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "RC2");
                    RC2CBCParameter rc2Params = RC2CBCParameter.getInstance((Object)params);
                    int effectiveKeySize = key.getEncoded().length * 8;
                    cipher.init(2, (Key)key, new RC2ParameterSpec(effectiveKeySize, rc2Params.getIV()));
                    break block17;
                }
                if (algId.equals("1.2.840.113549.3.4")) {
                    cipher = Cipher.getInstance("RC4", jceProvider);
                    SecretKeySpec key = new SecretKeySpec(secretKeyBytes, "RC4");
                    cipher.init(2, key);
                    break block17;
                }
                throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{algId}));
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_decode"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"RSA"}));
            }
            catch (NoSuchPaddingException e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_unsupported_alg", new String[]{"RSA"}));
            }
            catch (Exception e) {
                throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_pkcs7_internal_error"));
            }
        }
        return cipher;
    }
}

