/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.members;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.ModuleNotFoundException;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.ma.MAResponseGenerator;
import com.ibm.bi.platform.moser.core.metadata.util.SetIdForExpressionUtil;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.util.MoserMetadataContext;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.DatasetService;
import com.ibm.bi.platform.moser.core.rest.service.UserProfileService;
import com.ibm.bi.platform.moser.members.IMembersProvider;
import com.ibm.bi.platform.moser.members.MemberUtils;
import com.ibm.bi.platform.moser.members.MembersQuerySpecGenerator;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import javax.ws.rs.core.Response;

public class DQMMembersProvider
implements IMembersProvider {
    DatasetService mQueryService;
    IModuleObjectManager mModuleManager;
    String mConnectionSpec;

    DQMMembersProvider(DatasetService queryService, IModuleObjectManager moduleManager, String connectionSpec) {
        this.mQueryService = queryService;
        this.mModuleManager = moduleManager;
        this.mConnectionSpec = connectionSpec;
    }

    @Override
    public Response get(String moduleID, String type, String startAtPath, String containsFilterValue, boolean searchDescendants, boolean allProperties, int limit, int offset, String parameter) {
        String itemID = MemberUtils.extractItemID(startAtPath);
        Module module = this.getModule(moduleID, type, itemID);
        boolean searchMember = false;
        JSONObject querySpec = new MembersQuerySpecGenerator(module).toQuerySpec(startAtPath, containsFilterValue, searchDescendants, allProperties, searchMember, limit, offset, parameter, this.mConnectionSpec);
        return this.getData(moduleID, type, querySpec).toResponse();
    }

    private RESTClientResponse getData(String moduleID, String type, JSONObject querySpec) {
        return this.mQueryService.getData(moduleID, type, querySpec);
    }

    private Module getModule(String moduleID, String type, String itemID) {
        Module module;
        if (type == null) {
            MoserException e = new MoserException(MoserError.MSR_MEM_INVALID_TYPE);
            e.setHTTPStatus(Response.Status.BAD_REQUEST.getStatusCode());
            throw e;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(itemID);
        UseSpecType moduleType = this.mModuleManager.getModuleType(moduleID, type);
        if (UseSpecType.MODULE == moduleType) {
            module = this.mModuleManager.getBusinessModuleMetadata(moduleID, moduleType, ids, MoserMetadataContext.METADATA);
            SetIdForExpressionUtil.setIdForExpression((Module)module);
        } else {
            module = this.mModuleManager.getBaseModule(moduleID, moduleType, ids);
            if (UseSpecType.PACKAGE != moduleType) {
                MAResponseGenerator ma = new MAResponseGenerator(this.mModuleManager, true);
                module = ma.getMAResponse(moduleID, module, new ArrayList());
                MAResponseGenerator.cleanUse((String)moduleID, (Module)module);
            }
        }
        if (module == null) {
            if (UserProfileService.isSessionModule((String)moduleID)) {
                throw new ModuleNotFoundException(MoserError.MSR_MODULE_NOT_FOUND, moduleID);
            }
            MoserException e = new MoserException(MoserError.MSR_MEM_INVALID_MODULE);
            e.setHTTPStatus(Response.Status.BAD_REQUEST.getStatusCode());
            throw e;
        }
        return module;
    }

    @Override
    public JSONObject getMemberProperties(String moduleID, String memberID) {
        String levelID = null;
        int idx = memberID.indexOf("->");
        if (idx != -1) {
            levelID = memberID.substring(0, idx);
        }
        String type = "module";
        boolean allProperties = true;
        boolean searchMember = true;
        boolean searchDescendants = false;
        int limit = 100;
        Module module = this.getModule(moduleID, type, levelID);
        JSONObject querySpec = new MembersQuerySpecGenerator(module).toQuerySpec(levelID, memberID, searchDescendants, allProperties, searchMember, limit, 0, null, this.mConnectionSpec);
        return this.getData(moduleID, type, querySpec).getJSONObjectResponse();
    }
}

