/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.members;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetTypeEnabled;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.SortListType;
import com.ibm.bi.platform.moser.common.generated.metadata.SourceCategoryType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.members.MemberUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.Response;

public class MembersQuerySpecGenerator {
    private static final String OPERATION = "operation";
    private static final String DATAITEMS = "dataItems";
    private static final String ADD = "add";
    private static final String KEEP = "keep";
    private static final String CONNECTIONS = "connections";
    private static final String PARAMETER_VALUES = "parameterValues";
    private Module mModule;
    private JSONArray mSelection;
    private JSONObject mQuerySpec;

    public MembersQuerySpecGenerator(Module module) {
        this.mModule = module;
        MoserUtil.resolveModule((Module)module);
    }

    public JSONObject toQuerySpec(String startAtPath, String contains, boolean descendants, boolean allProperties, boolean searchMember, int limit, int offset, String parameter, String connectionSpec) {
        String itemId = this.getQueryItem(startAtPath, descendants);
        String projectionId = "id_members";
        this.createQuerySpec(itemId, projectionId, limit, offset, allProperties, parameter, connectionSpec);
        if (searchMember) {
            JSONArray values = new JSONArray();
            values.add((Object)contains);
            this.addAction(KEEP, "set", values);
        } else if (descendants && contains != null) {
            this.addFilterFunctionAction(startAtPath, contains);
        } else {
            this.addActionWithDetailFilters(itemId, startAtPath, contains, projectionId);
        }
        this.addSortForRelational(itemId);
        LoggerAdapter.trace((Object)this, (String)("Query Spec for members: " + this.mQuerySpec));
        return this.mQuerySpec;
    }

    private void addSortForRelational(String itemId) {
        QueryItem qi = MemberUtils.findColumn(this.mModule, itemId);
        if (qi.getSourceCategory() != null && SourceCategoryType.COLUMN != qi.getSourceCategory()) {
            return;
        }
        boolean bNeedSort = false;
        FacetType facet = qi.getFacetDefinition();
        if (facet == null) {
            bNeedSort = true;
        } else if (FacetTypeEnabled.AUTOMATIC == facet.getEnabled()) {
            SortListType sortList = facet.getSortList();
            if (sortList == null) {
                bNeedSort = true;
            } else {
                List sortItems = sortList.basicGetSortItem();
                boolean bl = bNeedSort = sortItems == null || sortItems.isEmpty();
            }
        }
        if (bNeedSort) {
            JSONObject sort = new JSONObject();
            sort.put((Object)"type", (Object)"asc");
            this.addAction("order", "sort", sort);
        }
    }

    private void createQuerySpec(String itemId, String projectionId, int limit, int offset, boolean allProperties, String parameter, String connectionSpec) {
        this.mQuerySpec = new JSONObject();
        this.mQuerySpec.put((Object)"version", (Object)"1");
        this.mQuerySpec.put((Object)"intent", (Object)"metadata");
        this.mQuerySpec.put((Object)"limit", (Object)limit);
        if (offset > 0) {
            this.mQuerySpec.put((Object)"offset", (Object)offset);
        }
        this.mQuerySpec.put((Object)"allProperties", (Object)allProperties);
        this.addDataItem(itemId, projectionId);
        if (connectionSpec != null) {
            try {
                JSONObject jConnSpec = JSONObject.parse((String)connectionSpec);
                JSONArray connections = (JSONArray)jConnSpec.get((Object)CONNECTIONS);
                if (connections != null && !connections.isEmpty()) {
                    this.mQuerySpec.put((Object)CONNECTIONS, (Object)connections);
                }
            }
            catch (IOException e) {
                LoggerAdapter.info((Object)this, (String)"Failed to parse connection spec.");
            }
        }
        if (parameter != null) {
            try {
                JSONObject jParameter = JSONObject.parse((String)parameter);
                JSONArray jParameterValues = (JSONArray)jParameter.get((Object)PARAMETER_VALUES);
                if (jParameterValues != null && !jParameterValues.isEmpty()) {
                    this.mQuerySpec.put((Object)PARAMETER_VALUES, (Object)jParameterValues);
                }
            }
            catch (IOException e) {
                LoggerAdapter.info((Object)this, (String)"Failed to parse prompt parameters spec.");
            }
        }
    }

    private JSONObject addDataItem(String itemId, String projectionId) {
        JSONArray projections;
        JSONArray dataItems = (JSONArray)this.mQuerySpec.get((Object)DATAITEMS);
        if (dataItems == null) {
            dataItems = new JSONArray();
            this.mQuerySpec.put((Object)DATAITEMS, (Object)dataItems);
            projections = new JSONArray();
            this.mQuerySpec.put((Object)"projections", (Object)projections);
        }
        JSONObject dataItem = new JSONObject();
        dataItems.add((Object)dataItem);
        dataItem.put((Object)"id", (Object)projectionId);
        dataItem.put((Object)"itemId", (Object)itemId);
        projections = (JSONArray)this.mQuerySpec.get((Object)"projections");
        projections.add((Object)projectionId);
        return dataItem;
    }

    private void addFilterFunctionAction(String startAtPath, String contains) {
        boolean ignoreCase = true;
        if (contains == null) {
            throw new IllegalArgumentException("descendants must be specified with a filter condition");
        }
        if (this.isFilteredMember(startAtPath)) {
            this.addAction(ADD, "descendants", MembersQuerySpecGenerator.getDescendantsAction(startAtPath));
        }
        this.addAction(KEEP, "filter", MembersQuerySpecGenerator.getFilterFunctionAction(contains, ignoreCase));
    }

    private static JSONObject getFilterFunctionAction(String contains, boolean ignoreCase) {
        JSONArray dataFilters = new JSONArray();
        MembersQuerySpecGenerator.addDataFilter(dataFilters, MembersQuerySpecGenerator.createDataFilterExpression("contains", contains, null, ignoreCase));
        return MembersQuerySpecGenerator.createFilterFunctionFilter(dataFilters);
    }

    private static JSONObject getDescendantsAction(String startAtPath) {
        JSONObject descendants = new JSONObject();
        descendants.put((Object)"member", (Object)startAtPath);
        descendants.put((Object)"distance", (Object)"1");
        descendants.put((Object)"flag", (Object)"self after");
        return descendants;
    }

    private static JSONObject createFilterFunctionFilter(JSONArray dataFilters) {
        if (dataFilters.size() == 1) {
            return (JSONObject)dataFilters.get(0);
        }
        JSONObject filter = new JSONObject();
        JSONArray andFilters = new JSONArray();
        filter.put((Object)"and", (Object)andFilters);
        for (Object df : dataFilters) {
            andFilters.add(df);
        }
        return filter;
    }

    private static void addDataFilter(JSONArray dataFilters, JSONObject filter) {
        if (filter != null) {
            dataFilters.add((Object)filter);
        }
    }

    private void addAction(String operation, String actionType, Object actionSpec) {
        this.addAction(operation, actionType, actionSpec, this.getSelection());
    }

    private void addAction(String operation, String actionType, Object actionSpec, JSONArray selection) {
        if (actionType != null) {
            JSONObject action = new JSONObject();
            action.put((Object)OPERATION, (Object)operation);
            selection.add((Object)action);
            action.put((Object)actionType, actionSpec);
        }
    }

    private JSONArray getSelection() {
        if (this.mSelection == null) {
            JSONArray dataItems = (JSONArray)this.mQuerySpec.get((Object)DATAITEMS);
            JSONObject dataItem = (JSONObject)dataItems.get(0);
            this.mSelection = new JSONArray();
            dataItem.put((Object)"selection", (Object)this.mSelection);
        }
        return this.mSelection;
    }

    private void addActionWithDetailFilters(String itemId, String startAtPath, String contains, String projectionId) {
        boolean ignoreCase = true;
        if (this.isFilteredMember(startAtPath)) {
            this.addAction(ADD, "children", startAtPath);
        } else {
            boolean hasFilter;
            QueryItem column = MemberUtils.findColumn(this.mModule, itemId);
            boolean bl = hasFilter = contains != null && !contains.isEmpty();
            if (column != null && !hasFilter && (SourceCategoryType.HIERARCHY_LEVEL.equals((Object)column.getSourceCategory()) || SourceCategoryType.HIERARCHY_PARENT_CHILD.equals((Object)column.getSourceCategory()))) {
                this.addAction(ADD, "rootMembers", Boolean.TRUE);
            }
        }
        this.addDetailFilter("contains", contains, projectionId, this.mQuerySpec, ignoreCase);
    }

    private String getQueryItem(String startAtPath, boolean descendants) {
        QueryItem hierarchy;
        String itemId = MemberUtils.extractItemID(startAtPath);
        QueryItem col = MemberUtils.findColumn(this.mModule, itemId);
        if (descendants && col != null && SourceCategoryType.LEVEL.equals((Object)col.getSourceCategory()) && (hierarchy = MemberUtils.getHierarchy(col)) != null) {
            return hierarchy.getIdForExpression();
        }
        if (col == null) {
            LoggerAdapter.info((Object)this, (String)("Column not found: " + itemId));
            MoserException e = new MoserException(MoserError.MSR_MEM_ITEMID_NOTFOUND);
            e.setHTTPStatus(Response.Status.BAD_REQUEST.getStatusCode());
            throw e;
        }
        return col.getIdForExpression();
    }

    private boolean isFilteredMember(String startAtPath) {
        return startAtPath.indexOf("->") != -1;
    }

    private static JSONObject createDetailFilter(JSONObject querySpec) {
        JSONArray filters = MembersQuerySpecGenerator.getOrCreateDetailFilters(querySpec);
        JSONObject filter = new JSONObject();
        filters.add((Object)filter);
        filter.put((Object)"type", (Object)"pre");
        return filter;
    }

    private static JSONArray getOrCreateDetailFilters(JSONObject querySpec) {
        JSONArray filters = (JSONArray)querySpec.get((Object)"filters");
        if (filters == null || filters.isEmpty()) {
            filters = new JSONArray();
            querySpec.put((Object)"filters", (Object)filters);
        }
        return filters;
    }

    private void addDetailFilter(String filterOperator, String value, String dataItemId, JSONObject querySpec, boolean ignoreCase) {
        if (value == null || value.isEmpty()) {
            return;
        }
        JSONObject filter = MembersQuerySpecGenerator.createDetailFilter(querySpec);
        JSONObject expression = MembersQuerySpecGenerator.createDataFilterExpression(filterOperator, value, dataItemId, ignoreCase);
        filter.put((Object)"expression", (Object)expression);
    }

    private static JSONObject createDataFilterExpression(String filterOperator, String value, String dataItemId, boolean ignoreCase) {
        if (value == null) {
            return null;
        }
        JSONObject expression = new JSONObject();
        if (dataItemId != null) {
            expression.put((Object)"dataItem", (Object)dataItemId);
        }
        expression.put((Object)"ignoreCase", (Object)ignoreCase);
        expression.put((Object)"operator", (Object)filterOperator);
        expression.put((Object)"valueType", (Object)"display");
        JSONArray values = new JSONArray();
        values.add((Object)value);
        expression.put((Object)"values", (Object)values);
        return expression;
    }
}

