/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.upgrade;

import com.ibm.neo.upgrade.IUpgradeDelta;
import com.ibm.neo.upgrade.IUpgradeLogger;
import com.ibm.neo.upgrade.NoOpUpgradeLogger;
import com.ibm.neo.upgrade.UpgradeException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractUpgradeDelta
implements IUpgradeDelta {
    @Override
    public IUpgradeDelta.IContext newContext() {
        return new BaseContext();
    }

    protected void assertEquals(Object expected, Object actual) throws UpgradeException {
        this.assertEquals(expected, actual, null);
    }

    protected void assertEquals(Object expected, Object actual, String message) throws UpgradeException {
        if (expected == null) {
            if (actual != null) {
                this.raiseException(message);
            }
        } else if (actual == null) {
            this.raiseException(message);
        } else if (!expected.equals(actual)) {
            this.raiseException(message);
        }
    }

    protected void assertTrue(boolean condition) throws UpgradeException {
        this.assertTrue(condition, null);
    }

    protected void assertTrue(boolean condition, String message) throws UpgradeException {
        if (!condition) {
            this.raiseException(message);
        }
    }

    protected void raiseException(String message) throws UpgradeException {
        if (message == null) {
            throw new UpgradeException();
        }
        throw new UpgradeException(message);
    }

    protected void wrapException(Throwable t) throws UpgradeException {
        if (t instanceof UpgradeException) {
            throw (UpgradeException)t;
        }
        throw new UpgradeException(t);
    }

    protected class BaseContext
    implements IUpgradeDelta.IContext {
        private IUpgradeLogger mLogger = new NoOpUpgradeLogger();
        private Map<String, Object> mValues;

        protected BaseContext() {
        }

        @Override
        public void setLogger(IUpgradeLogger logger) {
            this.mLogger = logger;
        }

        @Override
        public IUpgradeLogger getLogger() {
            return this.mLogger;
        }

        @Override
        public void setValue(String key, Object value) {
            if (this.mValues == null) {
                this.mValues = new HashMap<String, Object>();
            }
            this.mValues.put(key, value);
        }

        @Override
        public Object getValue(String key) {
            if (this.mValues == null) {
                return null;
            }
            return this.mValues.get(key);
        }

        @Override
        public <T> T getValue(String key, Class<T> type) {
            return type.cast(this.getValue(key));
        }
    }
}

