/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.upgrade;

import com.ibm.neo.upgrade.InvalidContentVersionException;
import com.ibm.neo.upgrade.UpgradeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class ContentVersion {
    public static final int CURRENT_VERSION;
    public static final String PROP_CURRENT_VERSION = "com.ibm.neo.upgrade.service.current-content-version";
    private static final String CONTENT_VERSION_FILE = "content.version.properties";
    private static final SortedSet<Integer> sSupportedVersions;

    public static boolean isSupportedVersion(int version) {
        return sSupportedVersions.contains(version);
    }

    public static SortedSet<Integer> getSupportedVersions() {
        return sSupportedVersions;
    }

    public static SortedSet<Integer> getSupportedVersions(int maxVersion) {
        TreeSet<Integer> supportedVersions = new TreeSet<Integer>();
        for (Integer version : ContentVersion.getSupportedVersions()) {
            if (version > maxVersion) continue;
            supportedVersions.add(version);
        }
        return Collections.unmodifiableSortedSet(supportedVersions);
    }

    static {
        InputStream contentVersionFile = ContentVersion.class.getClassLoader().getResourceAsStream(CONTENT_VERSION_FILE);
        if (contentVersionFile == null) {
            throw new InvalidContentVersionException("Cannot find a file called 'content.version.properties' on the classpath.");
        }
        Properties contentVersionFileProps = new Properties();
        try {
            contentVersionFileProps.load(contentVersionFile);
        }
        catch (IOException e) {
            throw new InvalidContentVersionException(e);
        }
        String versionSequence = contentVersionFileProps.getProperty("com.ibm.neo.upgrade.service.supported-content-versions");
        if (versionSequence == null) {
            throw new InvalidContentVersionException("Could not find the property 'com.ibm.neo.upgrade.service.supported-content-versions' in the file 'content.version.properties'.");
        }
        SortedSet<Integer> versionSet = UpgradeUtils.parseSortedPositiveIntegers(versionSequence);
        if (versionSet.isEmpty()) {
            throw new InvalidContentVersionException("There are no positive integers in the sequence '" + versionSequence + "'.");
        }
        sSupportedVersions = Collections.unmodifiableSortedSet(versionSet);
        String currentVersStr = System.getProperty(PROP_CURRENT_VERSION);
        if (currentVersStr == null) {
            currentVersStr = contentVersionFileProps.getProperty(PROP_CURRENT_VERSION);
        }
        if (!StringUtils.isEmpty((String)currentVersStr)) {
            try {
                CURRENT_VERSION = Integer.parseInt(currentVersStr);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Illegal property: content.version.current");
            }
        } else {
            CURRENT_VERSION = sSupportedVersions.last();
        }
    }
}

