/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.upgrade;

import com.ibm.neo.upgrade.IUpgradeServiceFactory;
import com.ibm.neo.upgrade.UpgradeException;
import java.util.Properties;

public class UpgradeServiceFactoryLocator {
    public static final String PROP_UPGRADE_SERVICE_FACTORY_IMPL = "com.ibm.neo.upgrade.service.factory-impl";
    public static final String DEFAULT_UPGRADE_SERVICE_FACTORY_IMPL = "com.ibm.neo.upgrade.UpgradeServiceFactory";

    public static IUpgradeServiceFactory getFactory(Properties configuration) throws UpgradeException {
        String serviceFactoryName = configuration.getProperty(PROP_UPGRADE_SERVICE_FACTORY_IMPL, DEFAULT_UPGRADE_SERVICE_FACTORY_IMPL);
        try {
            Class<?> factoryClass = Class.forName(serviceFactoryName);
            IUpgradeServiceFactory gatewayFactory = (IUpgradeServiceFactory)factoryClass.newInstance();
            return gatewayFactory;
        }
        catch (Exception ex) {
            throw new UpgradeException("Failed to load upgrade service factory class: " + serviceFactoryName, ex);
        }
    }
}

