/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.upgrade;

import com.ibm.neo.upgrade.InvalidContentVersionException;
import java.util.SortedSet;
import java.util.TreeSet;

public class UpgradeUtils {
    private UpgradeUtils() {
    }

    public static SortedSet<Integer> parseSortedPositiveIntegers(String versionSequence) throws InvalidContentVersionException {
        String[] tokens;
        TreeSet<Integer> versionSet = new TreeSet<Integer>();
        for (String token : tokens = versionSequence.split(",")) {
            Integer version;
            try {
                version = Integer.valueOf(token.trim());
            }
            catch (NumberFormatException e) {
                throw new InvalidContentVersionException("Unable to parse string '" + versionSequence + "' as comma-delimited list of positive integers.", e);
            }
            if (version < 0) {
                throw new InvalidContentVersionException("Unable to parse string '" + versionSequence + "' as comma-delimited list of positive integers.");
            }
            versionSet.add(version);
        }
        return versionSet;
    }
}

