/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist;

import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.EWriteConcern;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDropListener;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ProjectionBuilder;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.query.FieldSelector;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;

public abstract class AbstractDocumentCollection
implements IDocumentCollection {
    private final List<IDropListener> mDropListeners = new LinkedList<IDropListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDropListener(IDropListener listener) {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            this.mDropListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyDropped() {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            for (IDropListener listener : this.mDropListeners) {
                listener.onDropped(this);
            }
        }
    }

    @Override
    public IONObject get(IONObjectId id) throws PersistenceException {
        return this.get(id, (EReadPreference)null);
    }

    @Override
    public boolean supportsTail() throws PersistenceException {
        return this.isCapped() && this.supportsCursorOption(ECursorOption.TAILABLE);
    }

    @Override
    public IONObject get(IONObjectId id, IONObject projection) throws PersistenceException {
        return this.get(id, projection, null);
    }

    @Override
    public long count() throws PersistenceException {
        return this.count((EReadPreference)null);
    }

    @Override
    public long count(IONObject query) throws PersistenceException {
        return this.count(query, null);
    }

    @Override
    public IONObject findOne(IONObject query) throws PersistenceException {
        return this.findOne(query, (EReadPreference)null);
    }

    @Override
    public IONObject findOne(IONObject query, IONObject projection) throws PersistenceException {
        return this.findOne(query, projection, null);
    }

    @Override
    public IONArray aggregate(List<IONObject> pipelines) throws PersistenceException {
        return this.aggregate(pipelines, null);
    }

    @Override
    public boolean remove(IONObjectId id) throws PersistenceException {
        return this.remove(id, (EWriteConcern)null);
    }

    @Override
    public int remove(IONObject query) throws PersistenceException {
        return this.remove(query, (EWriteConcern)null);
    }

    @Override
    public void save(IONObject obj) throws PersistenceException {
        this.save(obj, null);
    }

    @Override
    public void insert(IONObject obj) throws PersistenceException {
        this.insert(obj, (EWriteConcern)null);
    }

    @Override
    public void insert(Collection<IONObject> col) throws PersistenceException {
        this.insert(col, (EWriteConcern)null);
    }

    @Override
    public int update(IONObjectId id, IONObject update) throws PersistenceException {
        return this.update(id, update, (EWriteConcern)null);
    }

    @Override
    public int update(IONObject query, IONObject update) throws PersistenceException {
        return this.update(query, update, false, true, null);
    }

    @Override
    public int update(IONObject query, IONObject update, EWriteConcern writeConcern) throws PersistenceException {
        return this.update(query, update, false, true, writeConcern);
    }

    @Override
    public int update(IONObject query, IONObject update, boolean upsert) throws PersistenceException {
        return this.update(query, update, upsert, true, null);
    }

    @Override
    public int update(IONObject query, IONObject update, boolean upsert, EWriteConcern writeConcern) throws PersistenceException {
        return this.update(query, update, upsert, true, writeConcern);
    }

    @Override
    public int update(IONObject query, IONObject update, boolean upsert, boolean multi) throws PersistenceException {
        return this.update(query, update, upsert, multi, null);
    }

    @Override
    public <T> ICursor<T> findAndProject(IONObject query, String fieldToProject, Class<T> fieldType) throws PersistenceException {
        IONObject projection = new ProjectionBuilder().include(fieldToProject).toDocument();
        return this.find(query, projection).project(fieldToProject, fieldType);
    }

    @Override
    public <T> T findOneAndProject(IONObject query, String fieldToProject, Class<T> fieldType) throws PersistenceException {
        return this.findOneAndProject(query, fieldToProject, fieldType, null);
    }

    @Override
    public <T> T findOneAndProject(IONObject query, String fieldToProject, Class<T> fieldType, EReadPreference readPref) throws PersistenceException {
        IONObject projection = new ProjectionBuilder().include(fieldToProject).toDocument();
        IONObject obj = this.findOne(query, projection, readPref);
        if (null != obj) {
            return fieldType.cast(new FieldSelector(fieldToProject).getFieldValue(obj));
        }
        return null;
    }

    @Override
    public <T> List<T> distinct(String field, Class<T> fieldType) throws PersistenceException {
        return this.distinct(field, fieldType, (EReadPreference)null);
    }

    @Override
    public <T> List<T> distinct(IONObject query, String field, Class<T> fieldType) throws PersistenceException {
        return this.distinct(query, field, fieldType, null);
    }

    @Override
    public ICursor<IONObject> tail(IONObject query, boolean noTimeout) throws PersistenceException {
        if (!this.supportsTail()) {
            throw new UnsupportedOperationException("Collection does not support tailing");
        }
        EnumSet<ECursorOption> opts = EnumSet.of(ECursorOption.AWAIT_DATA, ECursorOption.TAILABLE);
        if (noTimeout) {
            opts.add(ECursorOption.NO_TIMEOUT);
        }
        return this.find(query).setOptions(opts);
    }

    public String toString() {
        return this.getFullName();
    }

    public static String makeHashedIndexName(String key) {
        return key + "_hashed";
    }

    public static String makeSortedIndexName(String[] keys, ESortOrder[] sortOrders) {
        if (null == keys) {
            throw new NullArgumentException("keys");
        }
        if (null == sortOrders) {
            throw new NullArgumentException("sortOrders");
        }
        if (keys.length != sortOrders.length) {
            throw new IllegalArgumentException("keys.length != sortOrders.length");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                builder.append('_');
            }
            builder.append(keys[i]);
            if (ESortOrder.DESCENDING == sortOrders[i]) {
                builder.append("_-1");
                continue;
            }
            builder.append("_1");
        }
        return builder.toString();
    }
}

