/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import java.util.LinkedList;
import java.util.List;

public class AggregationPipelineBuilder {
    private final LinkedList<IONObject> mPipeline = new LinkedList();

    public AggregationPipelineBuilder() {
    }

    public AggregationPipelineBuilder(List<IONObject> pipelineIons) {
        for (IONObject ionObject : pipelineIons) {
            this.mPipeline.add((IONObject)ionObject.clone());
        }
    }

    public List<IONObject> toIONDocuments() {
        return this.mPipeline;
    }

    public AggregationPipelineBuilder reset() {
        this.mPipeline.clear();
        return this;
    }

    public AggregationPipelineBuilder match(IONObject query) {
        return this.match(query, false);
    }

    public AggregationPipelineBuilder match(IONObject query, boolean first) {
        IONObject match = new IONObjectBuilder().put(PipelineCmd.$match.name(), query).toDocument();
        if (first) {
            this.mPipeline.addFirst(match);
        } else {
            this.mPipeline.add(match);
        }
        return this;
    }

    public AggregationPipelineBuilder project(IONObject query) {
        this.mPipeline.add(new IONObjectBuilder().put(PipelineCmd.$project.name(), query).toDocument());
        return this;
    }

    public AggregationPipelineBuilder limit(IONObject query) {
        this.mPipeline.add(new IONObjectBuilder().put(PipelineCmd.$limit.name(), query).toDocument());
        return this;
    }

    public AggregationPipelineBuilder skip(IONObject query) {
        this.mPipeline.add(new IONObjectBuilder().put(PipelineCmd.$skip.name(), query).toDocument());
        return this;
    }

    public AggregationPipelineBuilder unwind(IONObject query) {
        this.mPipeline.add(new IONObjectBuilder().put(PipelineCmd.$unwind.name(), query).toDocument());
        return this;
    }

    public AggregationPipelineBuilder group(IONObject query) {
        this.mPipeline.add(new IONObjectBuilder().put(PipelineCmd.$group.name(), query).toDocument());
        return this;
    }

    public AggregationPipelineBuilder sort(IONObject query) {
        this.mPipeline.add(new IONObjectBuilder().put(PipelineCmd.$sort.name(), query).toDocument());
        return this;
    }

    public AggregationPipelineBuilder redact(IONObject query) {
        this.mPipeline.add(new IONObjectBuilder().put(PipelineCmd.$redact.name(), query).toDocument());
        return this;
    }

    public AggregationPipelineBuilder out(IONObject query) {
        this.mPipeline.addLast(new IONObjectBuilder().put(PipelineCmd.$out.name(), query).toDocument());
        return this;
    }

    public int size() {
        return this.mPipeline.size();
    }

    public IONObject get(PipelineCmd _cmd, int _index) {
        return this.mPipeline.get(_index).getIONObject(_cmd.name());
    }

    public IONObject replace(PipelineCmd _cmd, int _index, IONObject _piplineQuery) {
        IONObject pipeLineIon = this.mPipeline.get(_index);
        IONObject pipelineCmd = pipeLineIon.getIONObject(_cmd.name());
        if (pipelineCmd == null) {
            return null;
        }
        pipeLineIon.put(_cmd.name(), _piplineQuery);
        return pipelineCmd;
    }

    public static enum PipelineCmd {
        $match,
        $project,
        $limit,
        $skip,
        $unwind,
        $group,
        $sort,
        $redact,
        $out;

    }
}

