/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist;

import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import java.util.HashMap;
import java.util.Map;

public final class ConfigSet {
    static final String SETS_COL = "sets";
    static final String KEY_NAME = "name";
    static final String KEY_PROPS = "props";
    private final String mName;
    private final IDocumentCollection mSetsCollection;

    public ConfigSet(String name, IDocumentCollection setsCollection) {
        this.mName = name;
        this.mSetsCollection = setsCollection;
    }

    public String getName() {
        return this.mName;
    }

    public Map<String, Object> toMap() throws PersistenceException {
        IONObject props = this.mSetsCollection.findOneAndProject(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument(), KEY_PROPS, IONObject.class);
        if (null == props) {
            return new HashMap<String, Object>(1);
        }
        HashMap<String, Object> unescapedProps = new HashMap<String, Object>(props.size());
        for (Map.Entry e : props.entrySet()) {
            unescapedProps.put(ConfigSet.unescapePropertyKey((String)e.getKey()), e.getValue());
        }
        return unescapedProps;
    }

    public <T> T getProperty(String key, Class<T> asType) throws PersistenceException {
        return this.mSetsCollection.findOneAndProject(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument(), "props." + ConfigSet.escapePropertyKey(key), asType);
    }

    public void setProperty(String key, Object value) throws PersistenceException {
        while (0L == this.mSetsCollection.count(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument())) {
            IONObject setObj = new IONObjectBuilder().put(KEY_NAME, this.mName).put(KEY_PROPS, new IONObjectBuilder().put(ConfigSet.escapePropertyKey(key), value).toDocument()).toDocument();
            try {
                this.mSetsCollection.insert(setObj);
                return;
            }
            catch (PersistenceException.DuplicateKey ex) {
            }
        }
        this.mSetsCollection.update(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument(), new UpdateBuilder().set("props." + ConfigSet.escapePropertyKey(key), value).toDocument());
    }

    public void setProperties(Map<String, Object> props) throws PersistenceException {
        HashMap<String, Object> escapedProps = new HashMap<String, Object>(props.size());
        for (Map.Entry<String, Object> e : props.entrySet()) {
            escapedProps.put(ConfigSet.escapePropertyKey(e.getKey()), e.getValue());
        }
        while (0L == this.mSetsCollection.count(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument())) {
            IONObject setObj = new IONObjectBuilder().put(KEY_NAME, this.mName).put(KEY_PROPS, new IONObjectBuilder().putAll(escapedProps).toDocument()).toDocument();
            try {
                this.mSetsCollection.insert(setObj);
                return;
            }
            catch (PersistenceException.DuplicateKey ex) {
            }
        }
        UpdateBuilder updaterBuilder = new UpdateBuilder();
        for (Map.Entry e : escapedProps.entrySet()) {
            updaterBuilder.set("props." + (String)e.getKey(), e.getValue());
        }
        this.mSetsCollection.update(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument(), updaterBuilder.toDocument());
    }

    public void removeProperty(String key) throws PersistenceException {
        this.mSetsCollection.update(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument(), new UpdateBuilder().unset("props." + ConfigSet.escapePropertyKey(key)).toDocument());
    }

    public void clear() throws PersistenceException {
        this.mSetsCollection.remove(new QueryBuilder().equalTo(KEY_NAME, this.mName).toDocument());
    }

    private static String escapePropertyKey(String key) {
        return key.replaceAll("\\.", "@dot@");
    }

    private static String unescapePropertyKey(String key) {
        return key.replaceAll("@dot@", "\\.");
    }
}

