/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist;

import com.ibm.neo.persist.ESortOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class IndexInfo {
    private final String mName;
    private final String[] mKeys;
    private final ESortOrder[] mSortOrders;
    private final boolean mHashed;
    private final boolean mUnique;
    private final boolean mSparse;
    private final int mExpireAfterSeconds;

    public IndexInfo(String name, String[] keys, ESortOrder[] sortOrders, boolean isHashed, boolean isUnique, boolean isSparse, int expireAfterSeconds) {
        this.mName = name;
        this.mKeys = keys;
        this.mSortOrders = sortOrders;
        this.mHashed = isHashed;
        this.mUnique = isUnique;
        this.mSparse = isSparse;
        this.mExpireAfterSeconds = expireAfterSeconds;
    }

    public String getName() {
        return this.mName;
    }

    public String[] getKeys() {
        return this.mKeys;
    }

    public ESortOrder[] getSortOrders() {
        return this.mSortOrders;
    }

    public boolean isHashed() {
        return this.mHashed;
    }

    public boolean isTTL() {
        return -1 != this.mExpireAfterSeconds;
    }

    public boolean isUnique() {
        return this.mUnique;
    }

    public boolean isSparse() {
        return this.mSparse;
    }

    public int getExpireAfterSeconds() {
        return this.mExpireAfterSeconds;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.mName).append("keys", (Object[])this.mKeys).append("sortOrders", (Object[])this.mSortOrders).append("hashed", this.mHashed).append("unique", this.mUnique).append("sparse", this.mSparse).append("expireAfterSeconds", this.mExpireAfterSeconds).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.mName).append((Object[])this.mKeys).append((Object[])this.mSortOrders).append(this.mHashed).append(this.mUnique).append(this.mSparse).append(this.mExpireAfterSeconds).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexInfo)) {
            return false;
        }
        IndexInfo other = (IndexInfo)o;
        return new EqualsBuilder().append((Object)this.mName, (Object)other.mName).append((Object[])this.mKeys, (Object[])other.mKeys).append((Object[])this.mSortOrders, (Object[])other.mSortOrders).append(this.mHashed, other.mHashed).append(this.mUnique, other.mUnique).append(this.mSparse, other.mSparse).append(this.mExpireAfterSeconds, other.mExpireAfterSeconds).isEquals();
    }

    public boolean equalsIgnoreName(IndexInfo other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return new EqualsBuilder().append((Object[])this.mKeys, (Object[])other.mKeys).append((Object[])this.mSortOrders, (Object[])other.mSortOrders).append(this.mHashed, other.mHashed).append(this.mUnique, other.mUnique).append(this.mSparse, other.mSparse).append(this.mExpireAfterSeconds, other.mExpireAfterSeconds).isEquals();
    }
}

