/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.slice.ISlicer;

public class PersistenceException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final int code;

    public PersistenceException() {
        this.code = -1;
    }

    public PersistenceException(String message) {
        super(message);
        this.code = -1;
    }

    public PersistenceException(String message, int code) {
        super(message);
        this.code = code;
    }

    public PersistenceException(Throwable cause) {
        super(cause);
        this.code = -1;
    }

    public PersistenceException(String message, Throwable cause) {
        super(message, cause);
        this.code = -1;
    }

    public PersistenceException(String message, int code, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public final int getCode() {
        return this.code;
    }

    public static class RecoveryTimeout
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public RecoveryTimeout(Throwable cause) {
            super(cause);
        }
    }

    public static class SliceBoundary
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public SliceBoundary(String message) {
            super(message);
        }

        public SliceBoundary(String message, ISlicer slicer, IONObject ion) {
            super(SliceBoundary.buildMessage(message, slicer, ion));
        }

        private static String buildMessage(String message, ISlicer slicer, IONObject ion) {
            StringBuilder builder = new StringBuilder(message);
            String key = slicer.getKey();
            builder.append(";").append(slicer).append(";");
            if (ion == null) {
                builder.append("null");
            } else if (ion.containsKey(key)) {
                builder.append(key).append("=").append(ion.get(key));
            } else {
                builder.append("no key");
            }
            return builder.toString();
        }
    }

    public static class MD5ChecksumMismatch
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public MD5ChecksumMismatch(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class DatabaseAlreadyExists
    extends PersistenceException {
        private static final long serialVersionUID = 1L;
        private final String mDatabaseName;

        public DatabaseAlreadyExists(String message, String databaseName) {
            super(message);
            this.mDatabaseName = databaseName;
        }

        public String getName() {
            return this.mDatabaseName;
        }
    }

    public static class ExpiredLock
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public ExpiredLock() {
            super("Lock has expired");
        }
    }

    public static class DuplicateKey
    extends WriteFailure {
        private static final long serialVersionUID = 1L;

        @Deprecated
        public DuplicateKey(IONObject obj, String message) {
            super(message, -1, null);
        }

        public DuplicateKey(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class BulkWriteFailure
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public BulkWriteFailure(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class WriteFailure
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public WriteFailure(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class CommandFailure
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public CommandFailure(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class NetworkError
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public NetworkError(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class CursorNotFound
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public CursorNotFound(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class Unauthorized
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public Unauthorized(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class AuthenticationFailed
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public AuthenticationFailed(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class Interrupted
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public Interrupted(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class ExecutionTimeout
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public ExecutionTimeout(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class Timeout
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public Timeout(String message, int code, Throwable cause) {
            super(message, code, cause);
        }
    }

    public static class ConfigurationError
    extends PersistenceException {
        private static final long serialVersionUID = 1L;

        public ConfigurationError(String message) {
            super(message);
        }

        public ConfigurationError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

