/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist;

import com.ibm.neo.persist.ConfigSet;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.ETenantContentModel;
import com.ibm.neo.persist.ICatalog;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IDropListener;
import com.ibm.neo.persist.IPersistenceGateway;
import com.ibm.neo.persist.IPersistenceGatewayFactory;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.slice.ShiroTenantSlicer;
import com.ibm.neo.persist.slice.SlicedDocumentDatabase;
import com.ibm.neo.security.SubjectHelper;
import com.ibm.neo.util.TTLCache;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceService {
    public static final String PROP_GATEWAY_FACTORY = "com.ibm.neo.persist.gateway.factory";
    public static final String PROP_CONFIG_DATABASE_NAME = "com.ibm.neo.persist.config.db";
    public static final String DEFAULT_CONFIG_DATABASE_NAME = "config";
    public static final String DEFAULT_GATEWAY_FACTORY = "com.ibm.neo.persist.mongo.MongoPersistenceGatewayFactory";
    public static final String TENANT_SLICER_KEY = "@tenant@";
    private static final Pattern TENANT_DB_NAME_PATTERN = Pattern.compile("^(?:(.*)-)?tenant-((?:shared)|(?:[a-f0-9]+))(?:-v(\\d+))?$");
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceService.class);
    private static PersistenceService sInstance = null;
    private final Properties mConfiguration;
    private final IPersistenceGateway mGateway;
    private final String mConfigDatabaseName;
    private final TTLCache<TenantDatabaseCacheKey, IDocumentDatabase> mTenantDatabaseCache = new TTLCache(15L, TimeUnit.MINUTES);

    public static boolean isInitialized() {
        return null != sInstance;
    }

    public static void initialize(Properties config) throws PersistenceException {
        if (null != sInstance) {
            throw new IllegalStateException("PersistenceService was already initialized.");
        }
        LOGGER.info("Initializing PersistenceService singleton");
        sInstance = new PersistenceService(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (null != sInstance) {
            try {
                LOGGER.info("Disposing PersistenceService singleton");
                sInstance.dispose();
            }
            finally {
                sInstance = null;
            }
        }
    }

    public static PersistenceService getInstance() {
        if (null == sInstance) {
            throw new IllegalStateException("PersistenceService was not initialized.");
        }
        return sInstance;
    }

    protected PersistenceService() throws PersistenceException {
        this(new Properties());
    }

    public PersistenceService(Properties configuration) throws PersistenceException {
        IPersistenceGatewayFactory gatewayFactory;
        this.mConfiguration = new Properties();
        if (null != configuration) {
            this.mConfiguration.putAll((Map<?, ?>)configuration);
        }
        this.mConfigDatabaseName = this.mConfiguration.getProperty(PROP_CONFIG_DATABASE_NAME, DEFAULT_CONFIG_DATABASE_NAME);
        String gatewayFactoryName = this.mConfiguration.getProperty(PROP_GATEWAY_FACTORY, DEFAULT_GATEWAY_FACTORY);
        try {
            Class<?> factoryClass = Class.forName(gatewayFactoryName);
            gatewayFactory = (IPersistenceGatewayFactory)factoryClass.newInstance();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load gateway factory class: " + gatewayFactoryName, (Throwable)ex);
            throw new PersistenceException("Failed to load gateway factory class: " + gatewayFactoryName, ex);
        }
        this.mGateway = gatewayFactory.create(this.mConfiguration);
    }

    public IPersistenceGateway getGateway() {
        return this.mGateway;
    }

    public List<String> listDatabaseNames() throws PersistenceException {
        return this.mGateway.getDefaultCatalog().listDatabaseNames();
    }

    public IDocumentDatabase getDatabase(String databaseName) throws PersistenceException {
        return this.mGateway.getDefaultCatalog().getDatabase(databaseName);
    }

    public List<String> listTenantDatabaseNames() throws PersistenceException {
        return this.listTenantDatabaseNames(PersistenceService.getTenantContentVersion());
    }

    public List<String> listTenantDatabaseNames(Integer contentVersion) throws PersistenceException {
        String tenantId = PersistenceService.getCurrentTenantId();
        List<String> dbNames = this.mGateway.getTenantCatalog(tenantId).listDatabaseNames();
        Iterator<String> iter = dbNames.iterator();
        while (iter.hasNext()) {
            int actualContentVersion;
            String name = iter.next();
            Matcher matcher = TENANT_DB_NAME_PATTERN.matcher(name);
            if (!matcher.matches() || !"shared".equals(matcher.group(2)) && !tenantId.equals(matcher.group(2))) {
                iter.remove();
                continue;
            }
            if (contentVersion == null || (actualContentVersion = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3))) == contentVersion) continue;
            iter.remove();
        }
        return dbNames;
    }

    public static boolean isTenantDatabaseName(String databaseName) {
        Matcher matcher = TENANT_DB_NAME_PATTERN.matcher(databaseName);
        return matcher.matches();
    }

    public static boolean isSharedTenantDatabaseName(String databaseName) {
        Matcher matcher = TENANT_DB_NAME_PATTERN.matcher(databaseName);
        if (!matcher.matches()) {
            return false;
        }
        return "shared".equals(matcher.group(2));
    }

    public static int getContentVersionFromDatabaseName(String databaseName) {
        Matcher matcher = TENANT_DB_NAME_PATTERN.matcher(databaseName);
        if (!matcher.matches()) {
            return -1;
        }
        if (null == matcher.group(3)) {
            return 0;
        }
        return Integer.parseInt(matcher.group(3));
    }

    public IDocumentDatabase getTenantDatabase() throws PersistenceException {
        return this.getTenantDatabase(null, PersistenceService.getTenantContentVersion());
    }

    public IDocumentDatabase getTenantDatabase(String prefix) throws PersistenceException {
        return this.getTenantDatabase(prefix, PersistenceService.getTenantContentVersion());
    }

    public IDocumentDatabase getTenantDatabase(int contentVersion) throws PersistenceException {
        return this.getTenantDatabase(null, contentVersion);
    }

    public IDocumentDatabase getTenantDatabase(String prefix, int contentVersion) throws PersistenceException {
        String tenantId = PersistenceService.getCurrentTenantId();
        ETenantContentModel contentModel = PersistenceService.getTenantContentModel();
        ICatalog catalog = this.mGateway.getTenantCatalog(tenantId);
        final TenantDatabaseCacheKey key = new TenantDatabaseCacheKey(catalog, tenantId, prefix, contentModel, contentVersion);
        IDocumentDatabase db = (IDocumentDatabase)this.mTenantDatabaseCache.get((Object)key);
        if (null == db) {
            if (ETenantContentModel.PRIVATE == contentModel) {
                db = catalog.getDatabase(PersistenceService.makePrivateTenantDatabaseName(prefix, tenantId, contentVersion));
            } else {
                IDocumentDatabase sharedDb = catalog.getDatabase(PersistenceService.makeSharedTenantDatabaseName(prefix, contentVersion));
                db = new SlicedDocumentDatabase(sharedDb, new ShiroTenantSlicer(TENANT_SLICER_KEY));
            }
            db.addDropListener(new IDropListener(){

                @Override
                public void onDropped(Object o) {
                    PersistenceService.this.mTenantDatabaseCache.invalidate((Object)key);
                }
            });
            IDocumentDatabase conflict = (IDocumentDatabase)this.mTenantDatabaseCache.putIfAbsent((Object)key, (Object)db);
            if (null != conflict) {
                db = conflict;
            }
        }
        return db;
    }

    @Deprecated
    public ConfigSet getConfigSet(String name) throws PersistenceException {
        IDocumentDatabase configDb = this.getDatabase(this.mConfigDatabaseName);
        IDocumentCollection setsCol = configDb.getDocumentCollection("sets");
        setsCol.ensureSortedIndex(new String[]{"name"}, new ESortOrder[]{ESortOrder.ASCENDING}, true, false);
        return new ConfigSet(name, setsCol);
    }

    public Properties getConfiguration() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.mConfiguration);
        return copy;
    }

    public IONObjectId generateId() {
        return this.mGateway.generateId();
    }

    public boolean validateId(IONObjectId id) {
        return this.mGateway.validateId(id);
    }

    public void dispose() {
        this.mTenantDatabaseCache.clear();
        this.mGateway.dispose();
    }

    private static String makePrivateTenantDatabaseName(String prefix, String tenantId, int contentVersion) {
        StringBuilder builder = new StringBuilder();
        if (null != prefix && prefix.length() > 0) {
            builder.append(prefix).append('-');
        }
        builder.append("tenant-").append(tenantId);
        if (contentVersion > 0) {
            builder.append("-v").append(contentVersion);
        }
        return builder.toString();
    }

    private static String makeSharedTenantDatabaseName(String prefix, int contentVersion) {
        StringBuilder builder = new StringBuilder();
        if (null != prefix && prefix.length() > 0) {
            builder.append(prefix).append('-');
        }
        builder.append("tenant-shared");
        if (contentVersion > 0) {
            builder.append("-v").append(contentVersion);
        }
        return builder.toString();
    }

    private static int getTenantContentVersion() {
        Integer contentVersion = (Integer)SubjectHelper.getSessionAttribute((Subject)SecurityUtils.getSubject(), (String)"tenant.content.version", Integer.class, (boolean)false);
        if (null == contentVersion) {
            return 0;
        }
        return contentVersion;
    }

    private static String getCurrentTenantId() {
        return (String)SubjectHelper.getSessionAttribute((Subject)SecurityUtils.getSubject(), (String)"tenant.id", String.class, (boolean)true);
    }

    private static ETenantContentModel getTenantContentModel() {
        String contentModel = (String)SubjectHelper.getSessionAttribute((Subject)SecurityUtils.getSubject(), (String)"tenant.content.model", String.class, (boolean)true);
        return ETenantContentModel.valueOf(contentModel);
    }

    public static void checkBlackListedCollectionName(String name) throws PersistenceException {
    }

    private static final class TenantDatabaseCacheKey {
        private final ICatalog mCatalog;
        private final String mTenantId;
        private final String mPrefix;
        private final ETenantContentModel mContentModel;
        private final int mContentVersion;
        private final int mHashCode;

        TenantDatabaseCacheKey(ICatalog catalog, String tenantId, String prefix, ETenantContentModel contentModel, int contentVersion) {
            this.mCatalog = catalog;
            this.mTenantId = tenantId;
            this.mPrefix = prefix;
            this.mContentModel = contentModel;
            this.mContentVersion = contentVersion;
            this.mHashCode = new HashCodeBuilder().append((Object)this.mCatalog).append((Object)this.mTenantId).append((Object)this.mPrefix).append((Object)this.mContentModel).append(this.mContentVersion).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TenantDatabaseCacheKey)) {
                return false;
            }
            TenantDatabaseCacheKey other = (TenantDatabaseCacheKey)o;
            return new EqualsBuilder().append((Object)this.mCatalog, (Object)other.mCatalog).append((Object)this.mTenantId, (Object)other.mTenantId).append((Object)this.mPrefix, (Object)other.mPrefix).append((Object)this.mContentModel, (Object)other.mContentModel).append(this.mContentVersion, other.mContentVersion).isEquals();
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

