/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.persist.ion.IONObjectId;
import java.util.Collection;
import java.util.Map;

public class QueryBuilder {
    private final IONObjectBuilder mQuery = new IONObjectBuilder();

    public IONObject toDocument() {
        return this.mQuery.toDocument();
    }

    public QueryBuilder reset() {
        this.mQuery.reset();
        return this;
    }

    public QueryBuilder putAll(Map<String, Object> entries) {
        this.mQuery.putAll(entries);
        return this;
    }

    public QueryBuilder not(IONObject query) {
        this.mQuery.put("$not", query);
        return this;
    }

    public QueryBuilder or(IONObject ... queries) {
        this.mQuery.put("$or", new IONArray(queries));
        return this;
    }

    public QueryBuilder or(Collection<IONObject> queries) {
        this.mQuery.put("$or", new IONArray(queries));
        return this;
    }

    public QueryBuilder and(IONObject ... queries) {
        this.mQuery.put("$and", new IONArray(queries));
        return this;
    }

    public QueryBuilder and(Collection<IONObject> queries) {
        this.mQuery.put("$and", new IONArray(queries));
        return this;
    }

    public QueryBuilder nor(IONObject ... queries) {
        this.mQuery.put("$nor", new IONArray(queries));
        return this;
    }

    public QueryBuilder nor(Collection<IONObject> queries) {
        this.mQuery.put("$nor", new IONArray(queries));
        return this;
    }

    public QueryBuilder equalTo(String field, Object value) {
        if (null == field) {
            this.mQuery.put("$eq", value);
        } else {
            this.mQuery.put(field, value);
        }
        return this;
    }

    public QueryBuilder idEqualTo(IONObjectId id) {
        this.mQuery.put("_id", id);
        return this;
    }

    public QueryBuilder notEqualTo(String field, Object value) {
        if (null == field) {
            this.mQuery.put("$ne", value);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$ne", value).toDocument());
        }
        return this;
    }

    public QueryBuilder size(String field, Object value) {
        if (null == field) {
            this.mQuery.put("$size", value);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$size", value).toDocument());
        }
        return this;
    }

    public QueryBuilder greaterThan(String field, Object value) {
        if (null == field) {
            this.mQuery.put("$gt", value);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$gt", value).toDocument());
        }
        return this;
    }

    public QueryBuilder greaterThanOrEqualTo(String field, Object value) {
        if (null == field) {
            this.mQuery.put("$gte", value);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$gte", value).toDocument());
        }
        return this;
    }

    public QueryBuilder lessThan(String field, Object value) {
        if (null == field) {
            this.mQuery.put("$lt", value);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$lt", value).toDocument());
        }
        return this;
    }

    public QueryBuilder lessThanOrEqualTo(String field, Object value) {
        if (null == field) {
            this.mQuery.put("$lte", value);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$lte", value).toDocument());
        }
        return this;
    }

    public QueryBuilder in(String field, Object ... values) {
        if (null == field) {
            this.mQuery.put("$in", new IONArray(values));
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$in", new IONArray(values)).toDocument());
        }
        return this;
    }

    public QueryBuilder in(String field, Collection<?> values) {
        if (null == field) {
            this.mQuery.put("$in", new IONArray(values));
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$in", new IONArray(values)).toDocument());
        }
        return this;
    }

    public QueryBuilder notIn(String field, Object ... values) {
        if (null == field) {
            this.mQuery.put("$nin", new IONArray(values));
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$nin", new IONArray(values)).toDocument());
        }
        return this;
    }

    public QueryBuilder notIn(String field, Collection<?> values) {
        if (null == field) {
            this.mQuery.put("$nin", new IONArray(values));
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$nin", new IONArray(values)).toDocument());
        }
        return this;
    }

    public QueryBuilder exists(String field) {
        if (null == field) {
            this.mQuery.put("$exists", true);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$exists", true).toDocument());
        }
        return this;
    }

    public QueryBuilder notExists(String field) {
        if (null == field) {
            this.mQuery.put("$exists", false);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$exists", false).toDocument());
        }
        return this;
    }

    public QueryBuilder mod(String field, long divisor, long remainder) {
        if (null == field) {
            this.mQuery.put("$mod", new IONArray(divisor, remainder));
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$mod", new IONArray(divisor, remainder)).toDocument());
        }
        return this;
    }

    public QueryBuilder regex(String field, String expr, boolean insensitive, boolean multiline, boolean extended) {
        StringBuilder optionsBuilder = new StringBuilder(4);
        if (insensitive) {
            optionsBuilder.append('i');
        }
        if (multiline) {
            optionsBuilder.append('m');
        }
        if (extended) {
            optionsBuilder.append('x');
        }
        if (optionsBuilder.length() > 0) {
            if (null == field) {
                this.mQuery.put("$regex", expr);
            } else {
                this.mQuery.put(field, new IONObjectBuilder().put("$regex", expr).put("$options", optionsBuilder.toString()).toDocument());
            }
        } else if (null == field) {
            this.mQuery.put("$regex", expr);
        } else {
            this.mQuery.put(field, new IONObjectBuilder().put("$regex", expr).toDocument());
        }
        return this;
    }

    public QueryBuilder where(String jscriptExpr) {
        this.mQuery.put("$where", jscriptExpr);
        return this;
    }

    public QueryBuilder elemMatch(String field, Collection<IONObject> queries) {
        IONObject mergedQueries = new IONObject();
        for (IONObject q : queries) {
            mergedQueries.putAll(q);
        }
        this.mQuery.put(field, new IONObjectBuilder().put("$elemMatch", mergedQueries).toDocument());
        return this;
    }

    public QueryBuilder elemMatch(IONObject ... queries) {
        IONObject mergedQueries = new IONObject();
        for (IONObject q : queries) {
            mergedQueries.putAll(q);
        }
        this.mQuery.put("$elemMatch", mergedQueries);
        return this;
    }

    public QueryBuilder elemMatch(String field, IONObject ... queries) {
        IONObject mergedQueries = new IONObject();
        for (IONObject q : queries) {
            mergedQueries.putAll(q);
        }
        this.mQuery.put(field, new IONObjectBuilder().put("$elemMatch", mergedQueries).toDocument());
        return this;
    }
}

