/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.cursor;

import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.FieldSelector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FieldProjectingCursor<T>
implements ICursor<T> {
    private final ICursor<IONObject> mSource;
    private final FieldSelector mFieldSelector;
    private final Class<T> mFieldType;

    public FieldProjectingCursor(ICursor<IONObject> source, String fieldName, Class<T> fieldType) {
        this.mSource = source;
        this.mFieldSelector = new FieldSelector(fieldName);
        this.mFieldType = fieldType;
    }

    @Override
    public boolean supportsOption(ECursorOption option) throws PersistenceException {
        return this.mSource.supportsOption(option);
    }

    @Override
    public EnumSet<ECursorOption> getOptions() throws PersistenceException {
        return this.mSource.getOptions();
    }

    @Override
    public ICursor<T> setOptions(EnumSet<ECursorOption> options) throws PersistenceException {
        this.mSource.setOptions(options);
        return this;
    }

    @Override
    public boolean supportsMaxTime() throws PersistenceException {
        return this.mSource.supportsMaxTime();
    }

    @Override
    public ICursor<T> maxTime(long maxTime, TimeUnit timeUnit) throws PersistenceException {
        this.mSource.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ICursor<T> setReadPreference(EReadPreference readPref) throws PersistenceException {
        this.mSource.setReadPreference(readPref);
        return this;
    }

    @Override
    public void close() throws PersistenceException {
        this.mSource.close();
    }

    @Override
    public int count() throws PersistenceException {
        return this.mSource.count();
    }

    @Override
    public T current() throws PersistenceException {
        IONObject obj = this.mSource.current();
        if (null == obj) {
            return null;
        }
        return this.mFieldType.cast(this.mFieldSelector.getFieldValue(obj));
    }

    @Override
    public boolean hasNext() throws PersistenceException {
        return this.mSource.hasNext();
    }

    @Override
    public T next() throws PersistenceException {
        IONObject obj = this.mSource.next();
        if (null == obj) {
            return null;
        }
        return this.mFieldType.cast(this.mFieldSelector.getFieldValue(obj));
    }

    @Override
    public ICursor<T> sort(IONObject orderBy) throws PersistenceException {
        this.mSource.sort(orderBy);
        return this;
    }

    @Override
    public ICursor<T> sortNatural(ESortOrder order) throws PersistenceException {
        this.mSource.sortNatural(order);
        return this;
    }

    @Override
    public ICursor<T> limit(int limit) throws PersistenceException {
        this.mSource.limit(limit);
        return this;
    }

    @Override
    public <U> ICursor<U> project(String fieldName, Class<U> fieldType) throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> toListAndClose() throws PersistenceException {
        ArrayList<T> list = new ArrayList<T>(Math.max(10, this.count()));
        while (this.hasNext()) {
            list.add(this.next());
        }
        this.close();
        return list;
    }
}

