/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.cursor;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.cursor.DelegatingIONObjectCursor;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.QueryEvaluator;

public class FilteringCursor
extends DelegatingIONObjectCursor {
    private final QueryEvaluator mQueryEval;
    private IONObject mCurrent = null;
    private IONObject mNext = null;

    public FilteringCursor(ICursor<IONObject> source, IONObject query) throws PersistenceException {
        super(source);
        this.mQueryEval = new QueryEvaluator(query);
        this.fetchNext();
    }

    @Override
    public IONObject current() throws PersistenceException {
        return this.mCurrent;
    }

    @Override
    public boolean hasNext() throws PersistenceException {
        if (this.mNext == null) {
            this.fetchNext();
        }
        return null != this.mNext;
    }

    @Override
    public IONObject next() throws PersistenceException {
        this.mCurrent = this.mNext;
        this.fetchNext();
        return this.mCurrent;
    }

    private void fetchNext() throws PersistenceException {
        this.mNext = null;
        while (this.getSource().hasNext()) {
            IONObject obj = this.getSource().next();
            if (!this.mQueryEval.matches(obj)) continue;
            this.mNext = obj;
            break;
        }
    }
}

