/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.cursor;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.cursor.DelegatingIONObjectCursor;
import com.ibm.neo.persist.ion.IONObject;

public class LimitingCursor
extends DelegatingIONObjectCursor {
    private final long mLimit;
    private long mCount = 0L;
    private IONObject mCurrent = null;

    public LimitingCursor(ICursor<IONObject> source, long limit) {
        super(source);
        this.mLimit = limit;
    }

    @Override
    public IONObject current() throws PersistenceException {
        return this.mCurrent;
    }

    @Override
    public boolean hasNext() throws PersistenceException {
        return this.mCount < this.mLimit && this.getSource().hasNext();
    }

    @Override
    public IONObject next() throws PersistenceException {
        if (this.mCount >= this.mLimit) {
            return null;
        }
        ++this.mCount;
        this.mCurrent = this.getSource().next();
        return this.mCurrent;
    }
}

