/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.cursor;

import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SingletonCursor<T>
implements ICursor<T> {
    private static final byte BEFORE = 0;
    private static final byte AT = 1;
    private static final byte AFTER = 2;
    private final T mValue;
    private byte mState = 0;

    public SingletonCursor(T value) {
        this.mValue = value;
    }

    @Override
    public boolean supportsOption(ECursorOption option) throws PersistenceException {
        return false;
    }

    @Override
    public EnumSet<ECursorOption> getOptions() throws PersistenceException {
        return EnumSet.noneOf(ECursorOption.class);
    }

    @Override
    public ICursor<T> setOptions(EnumSet<ECursorOption> options) throws PersistenceException {
        return this;
    }

    @Override
    public boolean supportsMaxTime() throws PersistenceException {
        return false;
    }

    @Override
    public ICursor<T> maxTime(long maxTime, TimeUnit timeUnit) throws PersistenceException {
        return this;
    }

    @Override
    public ICursor<T> setReadPreference(EReadPreference readPref) throws PersistenceException {
        return this;
    }

    @Override
    public void close() throws PersistenceException {
        this.mState = (byte)2;
    }

    @Override
    public int count() throws PersistenceException {
        return 1;
    }

    @Override
    public T current() throws PersistenceException {
        switch (this.mState) {
            case 1: {
                return this.mValue;
            }
        }
        return null;
    }

    @Override
    public boolean hasNext() throws PersistenceException {
        return 0 == this.mState;
    }

    @Override
    public T next() throws PersistenceException {
        switch (this.mState) {
            case 0: {
                this.mState = 1;
                return this.mValue;
            }
            case 1: {
                this.mState = (byte)2;
                return null;
            }
        }
        return null;
    }

    @Override
    public ICursor<T> sort(IONObject orderBy) throws PersistenceException {
        return this;
    }

    @Override
    public ICursor<T> sortNatural(ESortOrder order) throws PersistenceException {
        return this;
    }

    @Override
    public ICursor<T> limit(int limit) throws PersistenceException {
        return this;
    }

    @Override
    public <U> ICursor<U> project(String fieldName, Class<U> fieldType) throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> toListAndClose() throws PersistenceException {
        ArrayList<T> list = new ArrayList<T>(1);
        while (this.hasNext()) {
            list.add(this.next());
        }
        this.close();
        return list;
    }
}

