/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.cursor;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.cursor.DelegatingIONObjectCursor;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.SortEvaluator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortingCursor
extends DelegatingIONObjectCursor {
    private final IONObject mSortSpec;
    private List<IONObject> mSortedDocuments;
    private int mIndex = -1;
    private IONObject mCurrent = null;

    public SortingCursor(ICursor<IONObject> source, IONObject sortSpec) {
        super(source);
        this.mSortSpec = sortSpec;
    }

    @Override
    public IONObject current() throws PersistenceException {
        return this.mCurrent;
    }

    @Override
    public boolean hasNext() throws PersistenceException {
        this.sortIfRequired();
        return this.mIndex + 1 < this.mSortedDocuments.size();
    }

    @Override
    public IONObject next() throws PersistenceException {
        this.sortIfRequired();
        if (this.mIndex + 1 >= this.mSortedDocuments.size()) {
            return null;
        }
        this.mCurrent = this.mSortedDocuments.get(++this.mIndex);
        return this.mCurrent;
    }

    private void sortIfRequired() throws PersistenceException {
        if (null != this.mSortedDocuments) {
            return;
        }
        this.mSortedDocuments = new ArrayList<IONObject>();
        while (this.getSource().hasNext()) {
            this.mSortedDocuments.add(this.getSource().next());
        }
        Collections.sort(this.mSortedDocuments, SortEvaluator.buildComparator(this.mSortSpec));
    }
}

