/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.neo.persist.ion.IONCodable;
import com.ibm.neo.persist.ion.IONCodecLibrary;
import com.ibm.neo.persist.ion.IONCodingException;
import com.ibm.neo.persist.ion.IONDecoder;
import com.ibm.neo.persist.ion.IONEncoder;
import com.ibm.neo.persist.ion.IONObject;
import java.util.HashMap;
import java.util.Map;

public class DefaultIONCodecLibrary
implements IONCodecLibrary {
    private final Map<Class<?>, String> mClass2TypeName = new HashMap();
    private final Map<String, Class<?>> mTypeName2Class = new HashMap();
    private final Map<String, IONEncoder> mTypeName2Encoder = new HashMap<String, IONEncoder>();
    private final Map<String, IONDecoder> mTypeName2Decoder = new HashMap<String, IONDecoder>();

    public void registerType(Class<?> classType, String typeName, String[] aliases, IONEncoder encoder, IONDecoder decoder) {
        this.mClass2TypeName.put(classType, typeName);
        this.mTypeName2Class.put(typeName, classType);
        this.mTypeName2Encoder.put(typeName, new TypeAnnotatingEncoder(encoder, typeName));
        this.mTypeName2Decoder.put(typeName, decoder);
        if (null != aliases) {
            for (String alias : aliases) {
                this.mTypeName2Class.put(alias, classType);
                this.mTypeName2Decoder.put(alias, decoder);
            }
        }
    }

    public void registerType(Class<?> classType, String typeName, IONEncoder encoder, IONDecoder decoder) {
        this.registerType(classType, typeName, null, encoder, decoder);
    }

    public void registerType(Class<? extends IONCodable> classType, String typeName, String[] aliases) {
        this.registerType(classType, typeName, aliases, new IONCodableEncoder(), new IONCodableDecoder(classType));
    }

    public void registerType(Class<? extends IONCodable> classType, String typeName) {
        this.registerType(classType, typeName, new IONCodableEncoder(), new IONCodableDecoder(classType));
    }

    @Override
    public IONEncoder findEncoder(Object obj) {
        if (null == obj) {
            return null;
        }
        String typeName = this.mClass2TypeName.get(obj.getClass());
        if (null == typeName) {
            return null;
        }
        return this.mTypeName2Encoder.get(typeName);
    }

    @Override
    public IONDecoder findDecoder(IONObject ionObj, Class<?> expectedType) {
        if (null == ionObj) {
            return null;
        }
        String typeName = ionObj.getString("__type");
        if (null == typeName && null != expectedType) {
            typeName = this.mClass2TypeName.get(expectedType);
        }
        if (null == typeName) {
            return null;
        }
        return this.mTypeName2Decoder.get(typeName);
    }

    private static final class IONCodableEncoder
    implements IONEncoder {
        private IONCodableEncoder() {
        }

        @Override
        public IONObject encode(Object obj) {
            IONObject ionObj = new IONObject();
            ((IONCodable)obj).encodeION(ionObj);
            return ionObj;
        }
    }

    private static final class IONCodableDecoder
    implements IONDecoder {
        private final Class<? extends IONCodable> mCodableType;

        IONCodableDecoder(Class<? extends IONCodable> codableType) {
            this.mCodableType = codableType;
        }

        @Override
        public <T> T decode(IONObject ionObj, Class<T> expectedType) {
            IONCodable codable;
            try {
                codable = this.mCodableType.newInstance();
            }
            catch (Exception ex) {
                throw new IONCodingException("Failed to instantiate object of type " + this.mCodableType.getName(), ex);
            }
            codable.decodeION(ionObj);
            return expectedType.cast(codable);
        }
    }

    private static final class TypeAnnotatingEncoder
    implements IONEncoder {
        private final IONEncoder mEncoder;
        private final String mTypeName;

        TypeAnnotatingEncoder(IONEncoder encoder, String typeName) {
            this.mEncoder = encoder;
            this.mTypeName = typeName;
        }

        @Override
        public IONObject encode(Object obj) {
            IONObject ionObj = this.mEncoder.encode(obj);
            ionObj.put("__type", this.mTypeName);
            return ionObj;
        }
    }
}

