/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONBinary;
import com.ibm.neo.persist.ion.IONDate;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONIncTimestamp;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.ion.IONTime;
import com.ibm.neo.persist.ion.IONTimestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

public class IONArray
extends ArrayList<Object>
implements IONArtifact {
    private static final long serialVersionUID = 1L;

    public IONArray() {
    }

    public IONArray(int initialCapacity) {
        super(initialCapacity);
    }

    public IONArray(Collection<?> initialValues) {
        super(initialValues);
    }

    public <E> IONArray(E ... initialValues) {
        super(Arrays.asList(initialValues));
    }

    @Override
    public JSONArtifact toJSONArtifact() {
        JSONArray jsonArr = new JSONArray(this.size());
        for (Object e : this) {
            jsonArr.add(IONHelper.toJSON(e));
        }
        return jsonArr;
    }

    public Date getDate(int index, Date defaultValue) {
        Date d = this.getDate(index);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public Date getDate(int index) {
        Object o = this.get(index);
        if (null == o) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof IONDate) {
            return ((IONDate)o).toDate();
        }
        if (o instanceof IONTimestamp) {
            return ((IONTimestamp)o).toDate();
        }
        if (o instanceof IONTime) {
            return ((IONTime)o).toDate();
        }
        throw new ClassCastException();
    }

    public IONDate getIONDate(int index) {
        Object o = this.get(index);
        if (null == o) {
            return null;
        }
        if (o instanceof IONDate) {
            return (IONDate)o;
        }
        if (o instanceof IONTimestamp) {
            return ((IONTimestamp)o).toIONDate();
        }
        if (o instanceof Date) {
            return new IONDate((Date)o);
        }
        throw new ClassCastException();
    }

    public IONDate getIONDate(int index, IONDate defaultValue) {
        IONDate d = this.getIONDate(index);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public IONTime getIONTime(int index) {
        Object o = this.get(index);
        if (null == o) {
            return null;
        }
        if (o instanceof IONTime) {
            return (IONTime)o;
        }
        if (o instanceof IONTimestamp) {
            return ((IONTimestamp)o).toIONTime();
        }
        if (o instanceof Date) {
            return new IONTime((Date)o);
        }
        throw new ClassCastException();
    }

    public IONTime getIONTime(int index, IONTime defaultValue) {
        IONTime t = this.getIONTime(index);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public IONTimestamp getIONTimestamp(int index) {
        Object o = this.get(index);
        if (null == o) {
            return null;
        }
        if (o instanceof IONTimestamp) {
            return (IONTimestamp)o;
        }
        if (o instanceof Date) {
            return new IONTimestamp((Date)o);
        }
        throw new ClassCastException();
    }

    public IONTimestamp getIONTimestamp(int index, IONTimestamp defaultValue) {
        IONTimestamp ts = this.getIONTimestamp(index);
        if (ts == null) {
            return defaultValue;
        }
        return ts;
    }

    public IONIncTimestamp getIONIncTimestamp(int index) {
        Object o = this.get(index);
        if (null == o) {
            return null;
        }
        if (o instanceof IONIncTimestamp) {
            return (IONIncTimestamp)o;
        }
        throw new ClassCastException();
    }

    public IONIncTimestamp getIONIncTimestamp(int index, IONIncTimestamp defaultValue) {
        IONIncTimestamp ts = this.getIONIncTimestamp(index);
        if (ts == null) {
            return defaultValue;
        }
        return ts;
    }

    public String getString(int index) {
        return (String)this.get(index);
    }

    public String getString(int index, String defaultValue) {
        String s = this.getString(index);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public Number getNumber(int index) {
        return (Number)this.get(index);
    }

    public Number getNumber(int index, Number defaultValue) {
        Number n = this.getNumber(index);
        if (n == null) {
            return defaultValue;
        }
        return n;
    }

    public int getInt(int index) {
        return this.getNumber(index).intValue();
    }

    public int getInt(int index, int defaultValue) {
        Number n = this.getNumber(index);
        if (n == null) {
            return defaultValue;
        }
        return n.intValue();
    }

    public long getLong(int index) {
        return this.getNumber(index).longValue();
    }

    public long getLong(int index, long defaultValue) {
        Number n = this.getNumber(index);
        if (n == null) {
            return defaultValue;
        }
        return n.longValue();
    }

    public float getFloat(int index) {
        return this.getNumber(index).floatValue();
    }

    public float getFloat(int index, float defaultValue) {
        Number n = this.getNumber(index);
        if (n == null) {
            return defaultValue;
        }
        return n.floatValue();
    }

    public double getDouble(int index) {
        return this.getNumber(index).doubleValue();
    }

    public double getDouble(int index, double defaultValue) {
        Number n = this.getNumber(index);
        if (n == null) {
            return defaultValue;
        }
        return n.doubleValue();
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        Boolean b = (Boolean)this.get(index);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public IONObjectId getIONObjectId(int index) {
        return (IONObjectId)this.get(index);
    }

    public IONObject getIONObject(int index) {
        return (IONObject)this.get(index);
    }

    public IONArray getIONArray(int index) {
        return (IONArray)this.get(index);
    }

    public IONBinary getIONBinary(int index) {
        return (IONBinary)this.get(index);
    }

    public <E extends Enum<E>> E getEnum(int index, Class<E> enumType) {
        String stringValue = this.getString(index);
        if (stringValue == null) {
            return null;
        }
        return Enum.valueOf(enumType, stringValue);
    }

    public <E extends Enum<E>> E getEnum(int index, Class<E> enumType, E defaultValue) {
        E e = this.getEnum(index, enumType);
        if (e == null) {
            return defaultValue;
        }
        return e;
    }

    @Override
    public IONArray duplicate() {
        IONArray array = new IONArray(this.size());
        for (Object element : this) {
            array.add(IONHelper.duplicateObject(element));
        }
        return array;
    }

    @Override
    public String toString() {
        try {
            return this.toJSONArtifact().serialize(true);
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    @Override
    public int compareTo(IONArtifact other) {
        IONArray o = (IONArray)other;
        if (o == null) {
            return 1;
        }
        int mySize = this.size();
        if (mySize != o.size()) {
            return mySize - o.size();
        }
        for (int i = 0; i < mySize; ++i) {
            Object myElement = this.get(i);
            Object otherElement = o.get(i);
            if (myElement == null) {
                if (otherElement == null) continue;
                return -1;
            }
            if (otherElement == null) {
                return 1;
            }
            int result = ((Comparable)myElement).compareTo(otherElement);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

