/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.persist.ion.IONArtifact;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.NullArgumentException;

public class IONBinary
implements IONArtifact {
    private final byte[] mData;

    public IONBinary(byte[] bytes) {
        if (null == bytes) {
            throw new NullArgumentException("bytes");
        }
        this.mData = bytes;
    }

    @Override
    public JSONArtifact toJSONArtifact() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"$binary", (Object)DatatypeConverter.printBase64Binary((byte[])this.mData));
        return jsonObj;
    }

    public byte[] getData() {
        return this.mData;
    }

    @Override
    public IONBinary duplicate() {
        return new IONBinary(Arrays.copyOf(this.mData, this.mData.length));
    }

    public String toString() {
        try {
            return this.toJSONArtifact().serialize(true);
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IONBinary)) {
            return false;
        }
        IONBinary other = (IONBinary)o;
        return Arrays.equals(this.mData, other.mData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mData);
    }

    @Override
    public int compareTo(IONArtifact other) {
        IONBinary o = (IONBinary)other;
        if (o == null) {
            return 1;
        }
        if (this.mData.length != o.mData.length) {
            return this.mData.length - o.mData.length;
        }
        for (int i = 0; i < this.mData.length; ++i) {
            if (this.mData[i] == o.mData[i]) continue;
            return this.mData[i] - o.mData[i];
        }
        return 0;
    }
}

