/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.neo.persist.ion.IONCodecLibrary;
import com.ibm.neo.persist.ion.IONCodingException;
import com.ibm.neo.persist.ion.IONDecoder;
import com.ibm.neo.persist.ion.IONEncoder;
import com.ibm.neo.persist.ion.IONObject;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentLinkedQueue;

public class IONCodingService {
    private static final ConcurrentLinkedQueue<IONCodecLibrary> sRegisteredLibs = new ConcurrentLinkedQueue();

    static IONEncoder findEncoder(Object obj) {
        for (IONCodecLibrary lib : sRegisteredLibs) {
            IONEncoder encoder = lib.findEncoder(obj);
            if (null == encoder) continue;
            return encoder;
        }
        return null;
    }

    static IONDecoder findDecoder(IONObject ionObj, Class<?> expectedType) {
        for (IONCodecLibrary lib : sRegisteredLibs) {
            IONDecoder decoder = lib.findDecoder(ionObj, expectedType);
            if (null == decoder) continue;
            return decoder;
        }
        return null;
    }

    public static void registerLibrary(IONCodecLibrary library) {
        sRegisteredLibs.add(library);
    }

    public static void deregisterLibrary(IONCodecLibrary library) {
        sRegisteredLibs.remove(library);
    }

    public static IONObject encode(Object obj) throws IONCodingException {
        if (null == obj) {
            return null;
        }
        IONEncoder encoder = IONCodingService.findEncoder(obj);
        if (null == encoder) {
            throw new IONCodingException("No suitable encoder could be found for type: " + obj.getClass().getSimpleName());
        }
        return encoder.encode(obj);
    }

    public static <T> T decode(IONObject ionObj, Class<T> expectedType) throws IONCodingException {
        if (null == ionObj) {
            return null;
        }
        IONDecoder decoder = IONCodingService.findDecoder(ionObj, expectedType);
        if (null == decoder) {
            throw new IONCodingException("No suitable decoder could be found.");
        }
        return decoder.decode(ionObj, expectedType);
    }

    static {
        ServiceLoader<IONCodecLibrary> loader = ServiceLoader.load(IONCodecLibrary.class);
        for (IONCodecLibrary lib : loader) {
            sRegisteredLibs.add(lib);
        }
    }
}

