/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IONDate
implements IONArtifact {
    public static final String KEY_YEAR = "year";
    public static final String KEY_MONTH = "month";
    public static final String KEY_DAY_OF_MONTH = "dayOfMonth";
    private final short mYear;
    private final short mMonth;
    private final short mDayOfMonth;

    public IONDate(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.mYear = (short)cal.get(1);
        this.mMonth = (short)cal.get(2);
        this.mDayOfMonth = (short)cal.get(5);
    }

    public IONDate(Calendar cal) {
        this.mYear = (short)cal.get(1);
        this.mMonth = (short)cal.get(2);
        this.mDayOfMonth = (short)cal.get(5);
    }

    public IONDate(int year, int month, int dayOfMonth) {
        this.mYear = (short)year;
        this.mMonth = (short)month;
        this.mDayOfMonth = (short)dayOfMonth;
    }

    public IONDate(IONObject dateObj) {
        this(dateObj.getInt(KEY_YEAR), dateObj.getInt(KEY_MONTH), dateObj.getInt(KEY_DAY_OF_MONTH));
    }

    @Override
    public IONDate duplicate() {
        return new IONDate(this.mYear, this.mMonth, this.mDayOfMonth);
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDayOfMonth() {
        return this.mDayOfMonth;
    }

    public Date toDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        this.toCalendar(cal);
        return cal.getTime();
    }

    public Calendar toCalendar(Calendar cal) {
        if (null == cal) {
            cal = Calendar.getInstance();
            cal.clear();
        }
        cal.set(1, this.mYear);
        cal.set(2, this.mMonth);
        cal.set(5, this.mDayOfMonth);
        return cal;
    }

    @Override
    public JSONArtifact toJSONArtifact() {
        JSONObject dateObj = new JSONObject();
        JSONObject innerObj = new JSONObject();
        dateObj.put((Object)"$ion-date", (Object)innerObj);
        innerObj.put((Object)KEY_YEAR, (Object)this.mYear);
        innerObj.put((Object)KEY_MONTH, (Object)this.mMonth);
        innerObj.put((Object)KEY_DAY_OF_MONTH, (Object)this.mDayOfMonth);
        return dateObj;
    }

    @Override
    public int compareTo(IONArtifact other) {
        IONDate o = (IONDate)other;
        if (o == null) {
            return 1;
        }
        if (this.mYear != o.mYear) {
            return this.mYear - o.mYear;
        }
        if (this.mMonth != o.mMonth) {
            return this.mMonth - o.mMonth;
        }
        return this.mDayOfMonth - o.mDayOfMonth;
    }

    public String toString() {
        try {
            return this.toJSONArtifact().serialize(true);
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IONDate)) {
            return false;
        }
        IONDate other = (IONDate)o;
        return new EqualsBuilder().append(this.mYear, other.mYear).append(this.mMonth, other.mMonth).append(this.mDayOfMonth, other.mDayOfMonth).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.mYear).append(this.mMonth).append(this.mDayOfMonth).toHashCode();
    }
}

