/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONBinary;
import com.ibm.neo.persist.ion.IONCodingException;
import com.ibm.neo.persist.ion.IONCodingService;
import com.ibm.neo.persist.ion.IONDate;
import com.ibm.neo.persist.ion.IONIncTimestamp;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.ion.IONTime;
import com.ibm.neo.persist.ion.IONTimestamp;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

public class IONHelper {
    private static final ThreadLocal<DateFormat> ISO_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            isoFormat.setTimeZone(TimeZone.getTimeZone((String)"UTC"));
            return isoFormat;
        }
    };

    public static boolean isJSONSupportedPrimitive(Object obj) {
        if (null == obj) {
            return true;
        }
        Class<?> clazz = obj.getClass();
        return String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz);
    }

    public static boolean isIONSupportedPrimitive(Object obj) {
        if (null == obj) {
            return true;
        }
        Class<?> clazz = obj.getClass();
        return String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    public static Object toJSON(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof JSONArtifact) {
            return obj;
        }
        if (obj instanceof IONArtifact) {
            return ((IONArtifact)obj).toJSONArtifact();
        }
        if (obj instanceof Date) {
            JSONObject dateObj = new JSONObject();
            dateObj.put((Object)"$date", (Object)((Date)obj).getTime());
            return dateObj;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            JSONArray arr = new JSONArray(col.size());
            for (Object e : col) {
                arr.add(IONHelper.toJSON(e));
            }
            return arr;
        }
        if (IONHelper.isJSONSupportedPrimitive(obj)) {
            return obj;
        }
        return IONCodingService.encode(obj).toJSONArtifact();
    }

    public static Object toION(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof IONArtifact || IONHelper.isIONSupportedPrimitive(obj)) {
            return obj;
        }
        if (obj instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)obj;
            if (jsonObj.containsKey((Object)"$oid")) {
                return new IONObjectId((String)jsonObj.get((Object)"$oid"));
            }
            if (jsonObj.containsKey((Object)"$binary")) {
                return new IONBinary(DatatypeConverter.parseBase64Binary((String)((String)jsonObj.get((Object)"$binary"))));
            }
            if (jsonObj.containsKey((Object)"$date")) {
                Object encodedDate = jsonObj.get((Object)"$date");
                if (null == encodedDate) {
                    return null;
                }
                if (encodedDate instanceof Number) {
                    return new Date(((Number)encodedDate).longValue());
                }
                if (encodedDate instanceof String) {
                    try {
                        return ISO_DATE_FORMAT.get().parse((String)encodedDate);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                throw new IONCodingException("Failed to parse date: " + (String)jsonObj.get((Object)"$date"));
            }
            if (jsonObj.containsKey((Object)"$ion-date")) {
                JSONObject dateObj = (JSONObject)jsonObj.get((Object)"$ion-date");
                return new IONDate(IONHelper.toIONObject(dateObj));
            }
            if (jsonObj.containsKey((Object)"$ion-time")) {
                JSONObject timeObj = (JSONObject)jsonObj.get((Object)"$ion-time");
                return new IONTime(IONHelper.toIONObject(timeObj));
            }
            if (jsonObj.containsKey((Object)"$ion-timestamp")) {
                JSONObject tsObj = (JSONObject)jsonObj.get((Object)"$ion-timestamp");
                return new IONTimestamp(IONHelper.toIONObject(tsObj));
            }
            if (jsonObj.containsKey((Object)"$timestamp")) {
                JSONObject tsObj = (JSONObject)jsonObj.get((Object)"$timestamp");
                return new IONIncTimestamp(IONHelper.toIONObject(tsObj));
            }
            return IONHelper.toIONObject(jsonObj);
        }
        if (obj instanceof Collection) {
            return IONHelper.toIONArray((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return IONHelper.toIONArray(obj);
        }
        return IONCodingService.encode(obj);
    }

    public static IONObject toIONObject(JSONObject jsonObj) {
        if (null == jsonObj) {
            return null;
        }
        IONObject ionObj = new IONObject();
        for (Map.Entry e : jsonObj.entrySet()) {
            ionObj.put(e.getKey(), IONHelper.toION(e.getValue()));
        }
        return ionObj;
    }

    public static IONArray toIONArray(Collection<?> collection) {
        if (null == collection) {
            return null;
        }
        IONArray ionArr = new IONArray(collection.size());
        for (Object e : collection) {
            ionArr.add(IONHelper.toION(e));
        }
        return ionArr;
    }

    public static IONArray toIONArray(Object array) {
        if (null == array) {
            return null;
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("array was not an array type");
        }
        int n = Array.getLength(array);
        IONArray ionArr = new IONArray(n);
        for (int i = 0; i < n; ++i) {
            ionArr.add(IONHelper.toION(Array.get(array, i)));
        }
        return ionArr;
    }

    public static <T> void toCollection(IONArray ionArr, Collection<T> collection) {
        if (null == ionArr) {
            return;
        }
        for (Object e : ionArr) {
            if (e instanceof IONObject) {
                collection.add(IONHelper.toPOJO((IONObject)e, Object.class));
                continue;
            }
            collection.add(e);
        }
    }

    public static <T> void toCollection(IONArray ionArr, Collection<T> collection, Class<T> elementType) {
        if (null == ionArr) {
            return;
        }
        for (Object e : ionArr) {
            if (e instanceof IONObject) {
                collection.add(IONHelper.toPOJO((IONObject)e, elementType));
                continue;
            }
            collection.add(elementType.cast(e));
        }
    }

    public static <T> T[] toArray(IONArray ionArr, T[] array) {
        int i;
        if (null == ionArr) {
            return array;
        }
        Class componentType = Object.class;
        if (null != array) {
            componentType = array.getClass().getComponentType();
        }
        if (null == array || ionArr.size() > array.length) {
            array = (Object[])Array.newInstance(componentType, ionArr.size());
        }
        for (i = 0; i < ionArr.size(); ++i) {
            Object e = ionArr.get(i);
            if (e instanceof IONObject) {
                if (IONObject.class.isAssignableFrom(componentType)) {
                    array[i] = e;
                    continue;
                }
                array[i] = IONHelper.toPOJO((IONObject)e, componentType);
                continue;
            }
            array[i] = e;
        }
        for (i = ionArr.size(); i < array.length; ++i) {
            array[i] = null;
        }
        return array;
    }

    public static <T> T toPOJO(IONObject ionObj, Class<T> returnType) {
        if (null == ionObj) {
            return null;
        }
        return IONCodingService.decode(ionObj, returnType);
    }

    public static Object parseJSONAsObject(String jsonStr) {
        JSONArtifact json;
        try {
            json = JSON.parse((String)jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        return IONHelper.toION(json);
    }

    public static IONArtifact parseJSON(String jsonStr) {
        JSONArtifact json;
        try {
            json = JSON.parse((String)jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        return (IONArtifact)IONHelper.toION(json);
    }

    public static IONObject parseJSONObject(String jsonStr) {
        try {
            return IONHelper.toIONObject(JSONObject.parse((String)jsonStr));
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public static IONArray parseJSONArray(String jsonStr) {
        try {
            return IONHelper.toIONArray(JSONArray.parse((String)jsonStr));
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public static Object duplicateObject(Object object) {
        if (object instanceof IONArtifact) {
            return ((IONArtifact)object).duplicate();
        }
        if (object instanceof Date) {
            return new Date(((Date)object).getTime());
        }
        return object;
    }
}

